package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait PlacementConstraintType {
  def unwrap: software.amazon.awssdk.services.ecs.model.PlacementConstraintType
}
object PlacementConstraintType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.PlacementConstraintType
  ): zio.aws.ecs.model.PlacementConstraintType = value match {
    case software.amazon.awssdk.services.ecs.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.PlacementConstraintType.DISTINCT_INSTANCE =>
      val r = distinctInstance
      r
    case software.amazon.awssdk.services.ecs.model.PlacementConstraintType.MEMBER_OF =>
      val r = memberOf
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementConstraintType =
      software.amazon.awssdk.services.ecs.model.PlacementConstraintType.UNKNOWN_TO_SDK_VERSION
  }
  case object distinctInstance
      extends zio.aws.ecs.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementConstraintType =
      software.amazon.awssdk.services.ecs.model.PlacementConstraintType.DISTINCT_INSTANCE
  }
  case object memberOf extends zio.aws.ecs.model.PlacementConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.PlacementConstraintType =
      software.amazon.awssdk.services.ecs.model.PlacementConstraintType.MEMBER_OF
  }
}
