package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListClustersResponse(
    clusterArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListClustersResponse = {
    import ListClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListClustersResponse
      .builder()
      .optionallyWith(
        clusterArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListClustersResponse.ReadOnly =
    zio.aws.ecs.model.ListClustersResponse.wrap(buildAwsValue())
}
object ListClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListClustersResponse =
      zio.aws.ecs.model.ListClustersResponse(
        clusterArns.map(value => value),
        nextToken.map(value => value)
      )
    def clusterArns: Optional[List[String]]
    def nextToken: Optional[String]
    def getClusterArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterArns", clusterArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListClustersResponse
  ) extends zio.aws.ecs.model.ListClustersResponse.ReadOnly {
    override val clusterArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListClustersResponse
  ): zio.aws.ecs.model.ListClustersResponse.ReadOnly = new Wrapper(impl)
}
