package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeClustersResponse(
    clusters: Optional[Iterable[zio.aws.ecs.model.Cluster]] = Optional.Absent,
    failures: Optional[Iterable[zio.aws.ecs.model.Failure]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeClustersResponse = {
    import DescribeClustersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
      .builder()
      .optionallyWith(
        clusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.clusters)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeClustersResponse.ReadOnly =
    zio.aws.ecs.model.DescribeClustersResponse.wrap(buildAwsValue())
}
object DescribeClustersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeClustersResponse =
      zio.aws.ecs.model.DescribeClustersResponse(
        clusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusters: Optional[List[zio.aws.ecs.model.Cluster.ReadOnly]]
    def failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getClusters
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Cluster.ReadOnly]] =
      AwsError.unwrapOptionField("clusters", clusters)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ) extends zio.aws.ecs.model.DescribeClustersResponse.ReadOnly {
    override val clusters: Optional[List[zio.aws.ecs.model.Cluster.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Cluster.wrap(item)
          }.toList
        )
    override val failures: Optional[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeClustersResponse
  ): zio.aws.ecs.model.DescribeClustersResponse.ReadOnly = new Wrapper(impl)
}
