package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.BoxedBoolean
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterContainerInstanceRequest(
    cluster: Optional[String] = Optional.Absent,
    containerInstance: String,
    force: Optional[BoxedBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest = {
    import DeregisterContainerInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstance(containerInstance: java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.DeregisterContainerInstanceRequest.ReadOnly =
    zio.aws.ecs.model.DeregisterContainerInstanceRequest.wrap(buildAwsValue())
}
object DeregisterContainerInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DeregisterContainerInstanceRequest =
      zio.aws.ecs.model.DeregisterContainerInstanceRequest(
        cluster.map(value => value),
        containerInstance,
        force.map(value => value)
      )
    def cluster: Optional[String]
    def containerInstance: String
    def force: Optional[BoxedBoolean]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstance: ZIO[Any, Nothing, String] =
      ZIO.succeed(containerInstance)
    def getForce: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest
  ) extends zio.aws.ecs.model.DeregisterContainerInstanceRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val containerInstance: String = impl.containerInstance(): String
    override val force: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: BoxedBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DeregisterContainerInstanceRequest
  ): zio.aws.ecs.model.DeregisterContainerInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
