package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ContainerInstanceField {
  def unwrap: software.amazon.awssdk.services.ecs.model.ContainerInstanceField
}
object ContainerInstanceField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ContainerInstanceField
  ): zio.aws.ecs.model.ContainerInstanceField = value match {
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceField.TAGS =>
      val r = TAGS
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceField.CONTAINER_INSTANCE_HEALTH =>
      val r = CONTAINER_INSTANCE_HEALTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ContainerInstanceField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceField =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.ContainerInstanceField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceField =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceField.TAGS
  }
  case object CONTAINER_INSTANCE_HEALTH
      extends zio.aws.ecs.model.ContainerInstanceField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceField =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceField.CONTAINER_INSTANCE_HEALTH
  }
}
