package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClusterConfiguration(
    executeCommandConfiguration: Optional[
      zio.aws.ecs.model.ExecuteCommandConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ClusterConfiguration = {
    import ClusterConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ClusterConfiguration
      .builder()
      .optionallyWith(
        executeCommandConfiguration.map(value => value.buildAwsValue())
      )(_.executeCommandConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ClusterConfiguration.ReadOnly =
    zio.aws.ecs.model.ClusterConfiguration.wrap(buildAwsValue())
}
object ClusterConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ClusterConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ClusterConfiguration =
      zio.aws.ecs.model.ClusterConfiguration(
        executeCommandConfiguration.map(value => value.asEditable)
      )
    def executeCommandConfiguration
        : Optional[zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly]
    def getExecuteCommandConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "executeCommandConfiguration",
      executeCommandConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ClusterConfiguration
  ) extends zio.aws.ecs.model.ClusterConfiguration.ReadOnly {
    override val executeCommandConfiguration
        : Optional[zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executeCommandConfiguration())
        .map(value => zio.aws.ecs.model.ExecuteCommandConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ClusterConfiguration
  ): zio.aws.ecs.model.ClusterConfiguration.ReadOnly = new Wrapper(impl)
}
