package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAccountSettingsRequest(
    name: Optional[zio.aws.ecs.model.SettingName] = Optional.Absent,
    value: Optional[String] = Optional.Absent,
    principalArn: Optional[String] = Optional.Absent,
    effectiveSettings: Optional[Boolean] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest = {
    import ListAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .optionallyWith(effectiveSettings.map(value => value: java.lang.Boolean))(
        _.effectiveSettings
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly =
    zio.aws.ecs.model.ListAccountSettingsRequest.wrap(buildAwsValue())
}
object ListAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAccountSettingsRequest =
      zio.aws.ecs.model.ListAccountSettingsRequest(
        name.map(value => value),
        value.map(value => value),
        principalArn.map(value => value),
        effectiveSettings.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def name: Optional[zio.aws.ecs.model.SettingName]
    def value: Optional[String]
    def principalArn: Optional[String]
    def effectiveSettings: Optional[Boolean]
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def getName: ZIO[Any, AwsError, zio.aws.ecs.model.SettingName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
    def getPrincipalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArn)
    def getEffectiveSettings: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("effectiveSettings", effectiveSettings)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ) extends zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly {
    override val name: Optional[zio.aws.ecs.model.SettingName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.ecs.model.SettingName.wrap(value))
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
    override val principalArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalArn())
      .map(value => value: String)
    override val effectiveSettings: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.effectiveSettings())
      .map(value => value: Boolean)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAccountSettingsRequest
  ): zio.aws.ecs.model.ListAccountSettingsRequest.ReadOnly = new Wrapper(impl)
}
