package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Volume(
    name: Optional[String] = Optional.Absent,
    host: Optional[zio.aws.ecs.model.HostVolumeProperties] = Optional.Absent,
    dockerVolumeConfiguration: Optional[
      zio.aws.ecs.model.DockerVolumeConfiguration
    ] = Optional.Absent,
    efsVolumeConfiguration: Optional[zio.aws.ecs.model.EFSVolumeConfiguration] =
      Optional.Absent,
    fsxWindowsFileServerVolumeConfiguration: Optional[
      zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Volume = {
    import Volume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Volume
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(host.map(value => value.buildAwsValue()))(_.host)
      .optionallyWith(
        dockerVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.dockerVolumeConfiguration)
      .optionallyWith(
        efsVolumeConfiguration.map(value => value.buildAwsValue())
      )(_.efsVolumeConfiguration)
      .optionallyWith(
        fsxWindowsFileServerVolumeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.fsxWindowsFileServerVolumeConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Volume.ReadOnly =
    zio.aws.ecs.model.Volume.wrap(buildAwsValue())
}
object Volume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Volume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Volume = zio.aws.ecs.model.Volume(
      name.map(value => value),
      host.map(value => value.asEditable),
      dockerVolumeConfiguration.map(value => value.asEditable),
      efsVolumeConfiguration.map(value => value.asEditable),
      fsxWindowsFileServerVolumeConfiguration.map(value => value.asEditable)
    )
    def name: Optional[String]
    def host: Optional[zio.aws.ecs.model.HostVolumeProperties.ReadOnly]
    def dockerVolumeConfiguration
        : Optional[zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly]
    def efsVolumeConfiguration
        : Optional[zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly]
    def fsxWindowsFileServerVolumeConfiguration: Optional[
      zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getHost
        : ZIO[Any, AwsError, zio.aws.ecs.model.HostVolumeProperties.ReadOnly] =
      AwsError.unwrapOptionField("host", host)
    def getDockerVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dockerVolumeConfiguration",
      dockerVolumeConfiguration
    )
    def getEfsVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "efsVolumeConfiguration",
      efsVolumeConfiguration
    )
    def getFsxWindowsFileServerVolumeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fsxWindowsFileServerVolumeConfiguration",
      fsxWindowsFileServerVolumeConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Volume
  ) extends zio.aws.ecs.model.Volume.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val host
        : Optional[zio.aws.ecs.model.HostVolumeProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.host())
        .map(value => zio.aws.ecs.model.HostVolumeProperties.wrap(value))
    override val dockerVolumeConfiguration
        : Optional[zio.aws.ecs.model.DockerVolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerVolumeConfiguration())
        .map(value => zio.aws.ecs.model.DockerVolumeConfiguration.wrap(value))
    override val efsVolumeConfiguration
        : Optional[zio.aws.ecs.model.EFSVolumeConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.efsVolumeConfiguration())
        .map(value => zio.aws.ecs.model.EFSVolumeConfiguration.wrap(value))
    override val fsxWindowsFileServerVolumeConfiguration: Optional[
      zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fsxWindowsFileServerVolumeConfiguration())
      .map(value =>
        zio.aws.ecs.model.FSxWindowsFileServerVolumeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Volume
  ): zio.aws.ecs.model.Volume.ReadOnly = new Wrapper(impl)
}
