package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTaskDefinitionResponse(
    taskDefinition: Optional[zio.aws.ecs.model.TaskDefinition] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse = {
    import RegisterTaskDefinitionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse
      .builder()
      .optionallyWith(taskDefinition.map(value => value.buildAwsValue()))(
        _.taskDefinition
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly =
    zio.aws.ecs.model.RegisterTaskDefinitionResponse.wrap(buildAwsValue())
}
object RegisterTaskDefinitionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RegisterTaskDefinitionResponse =
      zio.aws.ecs.model.RegisterTaskDefinitionResponse(
        taskDefinition.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def taskDefinition: Optional[zio.aws.ecs.model.TaskDefinition.ReadOnly]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getTaskDefinition
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinition.ReadOnly] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse
  ) extends zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly {
    override val taskDefinition
        : Optional[zio.aws.ecs.model.TaskDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinition())
        .map(value => zio.aws.ecs.model.TaskDefinition.wrap(value))
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionResponse
  ): zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly = new Wrapper(
    impl
  )
}
