package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterContainerInstanceResponse(
    containerInstance: Optional[zio.aws.ecs.model.ContainerInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse = {
    import RegisterContainerInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse
      .builder()
      .optionallyWith(containerInstance.map(value => value.buildAwsValue()))(
        _.containerInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RegisterContainerInstanceResponse.ReadOnly =
    zio.aws.ecs.model.RegisterContainerInstanceResponse.wrap(buildAwsValue())
}
object RegisterContainerInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RegisterContainerInstanceResponse =
      zio.aws.ecs.model.RegisterContainerInstanceResponse(
        containerInstance.map(value => value.asEditable)
      )
    def containerInstance
        : Optional[zio.aws.ecs.model.ContainerInstance.ReadOnly]
    def getContainerInstance
        : ZIO[Any, AwsError, zio.aws.ecs.model.ContainerInstance.ReadOnly] =
      AwsError.unwrapOptionField("containerInstance", containerInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse
  ) extends zio.aws.ecs.model.RegisterContainerInstanceResponse.ReadOnly {
    override val containerInstance
        : Optional[zio.aws.ecs.model.ContainerInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerInstance())
        .map(value => zio.aws.ecs.model.ContainerInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceResponse
  ): zio.aws.ecs.model.RegisterContainerInstanceResponse.ReadOnly = new Wrapper(
    impl
  )
}
