package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlacementConstraint(
    `type`: Optional[zio.aws.ecs.model.PlacementConstraintType] =
      Optional.Absent,
    expression: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.PlacementConstraint = {
    import PlacementConstraint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.PlacementConstraint
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(expression.map(value => value: java.lang.String))(
        _.expression
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.PlacementConstraint.ReadOnly =
    zio.aws.ecs.model.PlacementConstraint.wrap(buildAwsValue())
}
object PlacementConstraint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.PlacementConstraint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.PlacementConstraint =
      zio.aws.ecs.model.PlacementConstraint(
        `type`.map(value => value),
        expression.map(value => value)
      )
    def `type`: Optional[zio.aws.ecs.model.PlacementConstraintType]
    def expression: Optional[String]
    def getType: ZIO[Any, AwsError, zio.aws.ecs.model.PlacementConstraintType] =
      AwsError.unwrapOptionField("type", `type`)
    def getExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("expression", expression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.PlacementConstraint
  ) extends zio.aws.ecs.model.PlacementConstraint.ReadOnly {
    override val `type`: Optional[zio.aws.ecs.model.PlacementConstraintType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ecs.model.PlacementConstraintType.wrap(value))
    override val expression: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.expression())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.PlacementConstraint
  ): zio.aws.ecs.model.PlacementConstraint.ReadOnly = new Wrapper(impl)
}
