package zio.aws.ecs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class InstanceHealthCheckResult(
    `type`: Optional[zio.aws.ecs.model.InstanceHealthCheckType] =
      Optional.Absent,
    status: Optional[zio.aws.ecs.model.InstanceHealthCheckState] =
      Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent,
    lastStatusChange: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult = {
    import InstanceHealthCheckResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        lastStatusChange.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastStatusChange)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly =
    zio.aws.ecs.model.InstanceHealthCheckResult.wrap(buildAwsValue())
}
object InstanceHealthCheckResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.InstanceHealthCheckResult =
      zio.aws.ecs.model.InstanceHealthCheckResult(
        `type`.map(value => value),
        status.map(value => value),
        lastUpdated.map(value => value),
        lastStatusChange.map(value => value)
      )
    def `type`: Optional[zio.aws.ecs.model.InstanceHealthCheckType]
    def status: Optional[zio.aws.ecs.model.InstanceHealthCheckState]
    def lastUpdated: Optional[Timestamp]
    def lastStatusChange: Optional[Timestamp]
    def getType: ZIO[Any, AwsError, zio.aws.ecs.model.InstanceHealthCheckType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.InstanceHealthCheckState] =
      AwsError.unwrapOptionField("status", status)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getLastStatusChange: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastStatusChange", lastStatusChange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ) extends zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly {
    override val `type`: Optional[zio.aws.ecs.model.InstanceHealthCheckType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ecs.model.InstanceHealthCheckType.wrap(value))
    override val status: Optional[zio.aws.ecs.model.InstanceHealthCheckState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.InstanceHealthCheckState.wrap(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val lastStatusChange: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastStatusChange())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.InstanceHealthCheckResult
  ): zio.aws.ecs.model.InstanceHealthCheckResult.ReadOnly = new Wrapper(impl)
}
