package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionsRequest(
    familyPrefix: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ecs.model.TaskDefinitionStatus] = Optional.Absent,
    sort: Optional[zio.aws.ecs.model.SortOrder] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest = {
    import ListTaskDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
      .builder()
      .optionallyWith(familyPrefix.map(value => value: java.lang.String))(
        _.familyPrefix
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionsRequest.wrap(buildAwsValue())
}
object ListTaskDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionsRequest =
      zio.aws.ecs.model.ListTaskDefinitionsRequest(
        familyPrefix.map(value => value),
        status.map(value => value),
        sort.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def familyPrefix: Optional[String]
    def status: Optional[zio.aws.ecs.model.TaskDefinitionStatus]
    def sort: Optional[zio.aws.ecs.model.SortOrder]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getFamilyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("familyPrefix", familyPrefix)
    def getStatus: ZIO[Any, AwsError, zio.aws.ecs.model.TaskDefinitionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSort: ZIO[Any, AwsError, zio.aws.ecs.model.SortOrder] =
      AwsError.unwrapOptionField("sort", sort)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ) extends zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly {
    override val familyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.familyPrefix())
      .map(value => value: String)
    override val status: Optional[zio.aws.ecs.model.TaskDefinitionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.TaskDefinitionStatus.wrap(value))
    override val sort: Optional[zio.aws.ecs.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.ecs.model.SortOrder.wrap(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsRequest
  ): zio.aws.ecs.model.ListTaskDefinitionsRequest.ReadOnly = new Wrapper(impl)
}
