package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartTaskRequest(
    cluster: Optional[String] = Optional.Absent,
    containerInstances: Iterable[String],
    enableECSManagedTags: Optional[Boolean] = Optional.Absent,
    enableExecuteCommand: Optional[Boolean] = Optional.Absent,
    group: Optional[String] = Optional.Absent,
    networkConfiguration: Optional[zio.aws.ecs.model.NetworkConfiguration] =
      Optional.Absent,
    overrides: Optional[zio.aws.ecs.model.TaskOverride] = Optional.Absent,
    propagateTags: Optional[zio.aws.ecs.model.PropagateTags] = Optional.Absent,
    referenceId: Optional[String] = Optional.Absent,
    startedBy: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    taskDefinition: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.StartTaskRequest = {
    import StartTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.StartTaskRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstances(containerInstances.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .optionallyWith(group.map(value => value: java.lang.String))(_.group)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(overrides.map(value => value.buildAwsValue()))(
        _.overrides
      )
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(referenceId.map(value => value: java.lang.String))(
        _.referenceId
      )
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .taskDefinition(taskDefinition: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.StartTaskRequest.ReadOnly =
    zio.aws.ecs.model.StartTaskRequest.wrap(buildAwsValue())
}
object StartTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.StartTaskRequest =
      zio.aws.ecs.model.StartTaskRequest(
        cluster.map(value => value),
        containerInstances,
        enableECSManagedTags.map(value => value),
        enableExecuteCommand.map(value => value),
        group.map(value => value),
        networkConfiguration.map(value => value.asEditable),
        overrides.map(value => value.asEditable),
        propagateTags.map(value => value),
        referenceId.map(value => value),
        startedBy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskDefinition
      )
    def cluster: Optional[String]
    def containerInstances: List[String]
    def enableECSManagedTags: Optional[Boolean]
    def enableExecuteCommand: Optional[Boolean]
    def group: Optional[String]
    def networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly]
    def propagateTags: Optional[zio.aws.ecs.model.PropagateTags]
    def referenceId: Optional[String]
    def startedBy: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def taskDefinition: String
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstances: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(containerInstances)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
    def getGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("group", group)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getOverrides
        : ZIO[Any, AwsError, zio.aws.ecs.model.TaskOverride.ReadOnly] =
      AwsError.unwrapOptionField("overrides", overrides)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getReferenceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("referenceId", referenceId)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTaskDefinition: ZIO[Any, Nothing, String] =
      ZIO.succeed(taskDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ) extends zio.aws.ecs.model.StartTaskRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val containerInstances: List[String] = impl
      .containerInstances()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val enableECSManagedTags: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableECSManagedTags())
      .map(value => value: Boolean)
    override val enableExecuteCommand: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableExecuteCommand())
      .map(value => value: Boolean)
    override val group: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => value: String)
    override val networkConfiguration
        : Optional[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkConfiguration())
        .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val overrides: Optional[zio.aws.ecs.model.TaskOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value => zio.aws.ecs.model.TaskOverride.wrap(value))
    override val propagateTags: Optional[zio.aws.ecs.model.PropagateTags] =
      zio.aws.core.internal
        .optionalFromNullable(impl.propagateTags())
        .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val referenceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceId())
      .map(value => value: String)
    override val startedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val taskDefinition: String = impl.taskDefinition(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.StartTaskRequest
  ): zio.aws.ecs.model.StartTaskRequest.ReadOnly = new Wrapper(impl)
}
