package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.SensitiveString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Session(
    sessionId: Optional[String] = Optional.Absent,
    streamUrl: Optional[String] = Optional.Absent,
    tokenValue: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Session = {
    import Session.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Session
      .builder()
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(streamUrl.map(value => value: java.lang.String))(
        _.streamUrl
      )
      .optionallyWith(
        tokenValue.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.tokenValue)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Session.ReadOnly =
    zio.aws.ecs.model.Session.wrap(buildAwsValue())
}
object Session {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Session] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Session = zio.aws.ecs.model.Session(
      sessionId.map(value => value),
      streamUrl.map(value => value),
      tokenValue.map(value => value)
    )
    def sessionId: Optional[String]
    def streamUrl: Optional[String]
    def tokenValue: Optional[SensitiveString]
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getStreamUrl: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamUrl", streamUrl)
    def getTokenValue: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("tokenValue", tokenValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Session
  ) extends zio.aws.ecs.model.Session.ReadOnly {
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
    override val streamUrl: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamUrl())
      .map(value => value: String)
    override val tokenValue: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenValue())
      .map(value => zio.aws.ecs.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Session
  ): zio.aws.ecs.model.Session.ReadOnly = new Wrapper(impl)
}
