package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterContainerInstanceRequest(
    cluster: Optional[String] = Optional.Absent,
    instanceIdentityDocument: Optional[String] = Optional.Absent,
    instanceIdentityDocumentSignature: Optional[String] = Optional.Absent,
    totalResources: Optional[Iterable[zio.aws.ecs.model.Resource]] =
      Optional.Absent,
    versionInfo: Optional[zio.aws.ecs.model.VersionInfo] = Optional.Absent,
    containerInstanceArn: Optional[String] = Optional.Absent,
    attributes: Optional[Iterable[zio.aws.ecs.model.Attribute]] =
      Optional.Absent,
    platformDevices: Optional[Iterable[zio.aws.ecs.model.PlatformDevice]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest = {
    import RegisterContainerInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(
        instanceIdentityDocument.map(value => value: java.lang.String)
      )(_.instanceIdentityDocument)
      .optionallyWith(
        instanceIdentityDocumentSignature.map(value => value: java.lang.String)
      )(_.instanceIdentityDocumentSignature)
      .optionallyWith(
        totalResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.totalResources)
      .optionallyWith(versionInfo.map(value => value.buildAwsValue()))(
        _.versionInfo
      )
      .optionallyWith(
        containerInstanceArn.map(value => value: java.lang.String)
      )(_.containerInstanceArn)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        platformDevices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.platformDevices)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RegisterContainerInstanceRequest.ReadOnly =
    zio.aws.ecs.model.RegisterContainerInstanceRequest.wrap(buildAwsValue())
}
object RegisterContainerInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RegisterContainerInstanceRequest =
      zio.aws.ecs.model.RegisterContainerInstanceRequest(
        cluster.map(value => value),
        instanceIdentityDocument.map(value => value),
        instanceIdentityDocumentSignature.map(value => value),
        totalResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        versionInfo.map(value => value.asEditable),
        containerInstanceArn.map(value => value),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        platformDevices.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cluster: Optional[String]
    def instanceIdentityDocument: Optional[String]
    def instanceIdentityDocumentSignature: Optional[String]
    def totalResources: Optional[List[zio.aws.ecs.model.Resource.ReadOnly]]
    def versionInfo: Optional[zio.aws.ecs.model.VersionInfo.ReadOnly]
    def containerInstanceArn: Optional[String]
    def attributes: Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]]
    def platformDevices
        : Optional[List[zio.aws.ecs.model.PlatformDevice.ReadOnly]]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getInstanceIdentityDocument: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("instanceIdentityDocument", instanceIdentityDocument)
    def getInstanceIdentityDocumentSignature: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "instanceIdentityDocumentSignature",
        instanceIdentityDocumentSignature
      )
    def getTotalResources
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("totalResources", totalResources)
    def getVersionInfo
        : ZIO[Any, AwsError, zio.aws.ecs.model.VersionInfo.ReadOnly] =
      AwsError.unwrapOptionField("versionInfo", versionInfo)
    def getContainerInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstanceArn", containerInstanceArn)
    def getAttributes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getPlatformDevices
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.PlatformDevice.ReadOnly]] =
      AwsError.unwrapOptionField("platformDevices", platformDevices)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest
  ) extends zio.aws.ecs.model.RegisterContainerInstanceRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val instanceIdentityDocument: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIdentityDocument())
        .map(value => value: String)
    override val instanceIdentityDocumentSignature: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceIdentityDocumentSignature())
        .map(value => value: String)
    override val totalResources
        : Optional[List[zio.aws.ecs.model.Resource.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Resource.wrap(item)
          }.toList
        )
    override val versionInfo: Optional[zio.aws.ecs.model.VersionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionInfo())
        .map(value => zio.aws.ecs.model.VersionInfo.wrap(value))
    override val containerInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerInstanceArn())
      .map(value => value: String)
    override val attributes
        : Optional[List[zio.aws.ecs.model.Attribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Attribute.wrap(item)
          }.toList
        )
    override val platformDevices
        : Optional[List[zio.aws.ecs.model.PlatformDevice.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformDevices())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PlatformDevice.wrap(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RegisterContainerInstanceRequest
  ): zio.aws.ecs.model.RegisterContainerInstanceRequest.ReadOnly = new Wrapper(
    impl
  )
}
