package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{BoxedBoolean, BoxedInteger, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ContainerDefinition(
    name: Optional[String] = Optional.Absent,
    image: Optional[String] = Optional.Absent,
    repositoryCredentials: Optional[zio.aws.ecs.model.RepositoryCredentials] =
      Optional.Absent,
    cpu: Optional[Integer] = Optional.Absent,
    memory: Optional[BoxedInteger] = Optional.Absent,
    memoryReservation: Optional[BoxedInteger] = Optional.Absent,
    links: Optional[Iterable[String]] = Optional.Absent,
    portMappings: Optional[Iterable[zio.aws.ecs.model.PortMapping]] =
      Optional.Absent,
    essential: Optional[BoxedBoolean] = Optional.Absent,
    entryPoint: Optional[Iterable[String]] = Optional.Absent,
    command: Optional[Iterable[String]] = Optional.Absent,
    environment: Optional[Iterable[zio.aws.ecs.model.KeyValuePair]] =
      Optional.Absent,
    environmentFiles: Optional[Iterable[zio.aws.ecs.model.EnvironmentFile]] =
      Optional.Absent,
    mountPoints: Optional[Iterable[zio.aws.ecs.model.MountPoint]] =
      Optional.Absent,
    volumesFrom: Optional[Iterable[zio.aws.ecs.model.VolumeFrom]] =
      Optional.Absent,
    linuxParameters: Optional[zio.aws.ecs.model.LinuxParameters] =
      Optional.Absent,
    secrets: Optional[Iterable[zio.aws.ecs.model.Secret]] = Optional.Absent,
    dependsOn: Optional[Iterable[zio.aws.ecs.model.ContainerDependency]] =
      Optional.Absent,
    startTimeout: Optional[BoxedInteger] = Optional.Absent,
    stopTimeout: Optional[BoxedInteger] = Optional.Absent,
    hostname: Optional[String] = Optional.Absent,
    user: Optional[String] = Optional.Absent,
    workingDirectory: Optional[String] = Optional.Absent,
    disableNetworking: Optional[BoxedBoolean] = Optional.Absent,
    privileged: Optional[BoxedBoolean] = Optional.Absent,
    readonlyRootFilesystem: Optional[BoxedBoolean] = Optional.Absent,
    dnsServers: Optional[Iterable[String]] = Optional.Absent,
    dnsSearchDomains: Optional[Iterable[String]] = Optional.Absent,
    extraHosts: Optional[Iterable[zio.aws.ecs.model.HostEntry]] =
      Optional.Absent,
    dockerSecurityOptions: Optional[Iterable[String]] = Optional.Absent,
    interactive: Optional[BoxedBoolean] = Optional.Absent,
    pseudoTerminal: Optional[BoxedBoolean] = Optional.Absent,
    dockerLabels: Optional[Map[String, String]] = Optional.Absent,
    ulimits: Optional[Iterable[zio.aws.ecs.model.Ulimit]] = Optional.Absent,
    logConfiguration: Optional[zio.aws.ecs.model.LogConfiguration] =
      Optional.Absent,
    healthCheck: Optional[zio.aws.ecs.model.HealthCheck] = Optional.Absent,
    systemControls: Optional[Iterable[zio.aws.ecs.model.SystemControl]] =
      Optional.Absent,
    resourceRequirements: Optional[
      Iterable[zio.aws.ecs.model.ResourceRequirement]
    ] = Optional.Absent,
    firelensConfiguration: Optional[zio.aws.ecs.model.FirelensConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ContainerDefinition = {
    import ContainerDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ContainerDefinition
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(image.map(value => value: java.lang.String))(_.image)
      .optionallyWith(
        repositoryCredentials.map(value => value.buildAwsValue())
      )(_.repositoryCredentials)
      .optionallyWith(cpu.map(value => value: java.lang.Integer))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.Integer))(_.memory)
      .optionallyWith(memoryReservation.map(value => value: java.lang.Integer))(
        _.memoryReservation
      )
      .optionallyWith(
        links.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.links)
      .optionallyWith(
        portMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.portMappings)
      .optionallyWith(essential.map(value => value: java.lang.Boolean))(
        _.essential
      )
      .optionallyWith(
        entryPoint.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.entryPoint)
      .optionallyWith(
        command.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.command)
      .optionallyWith(
        environment.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environment)
      .optionallyWith(
        environmentFiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.environmentFiles)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(
        volumesFrom.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumesFrom)
      .optionallyWith(linuxParameters.map(value => value.buildAwsValue()))(
        _.linuxParameters
      )
      .optionallyWith(
        secrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.secrets)
      .optionallyWith(
        dependsOn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dependsOn)
      .optionallyWith(startTimeout.map(value => value: java.lang.Integer))(
        _.startTimeout
      )
      .optionallyWith(stopTimeout.map(value => value: java.lang.Integer))(
        _.stopTimeout
      )
      .optionallyWith(hostname.map(value => value: java.lang.String))(
        _.hostname
      )
      .optionallyWith(user.map(value => value: java.lang.String))(_.user)
      .optionallyWith(workingDirectory.map(value => value: java.lang.String))(
        _.workingDirectory
      )
      .optionallyWith(disableNetworking.map(value => value: java.lang.Boolean))(
        _.disableNetworking
      )
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .optionallyWith(
        readonlyRootFilesystem.map(value => value: java.lang.Boolean)
      )(_.readonlyRootFilesystem)
      .optionallyWith(
        dnsServers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsServers)
      .optionallyWith(
        dnsSearchDomains.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dnsSearchDomains)
      .optionallyWith(
        extraHosts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extraHosts)
      .optionallyWith(
        dockerSecurityOptions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.dockerSecurityOptions)
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(pseudoTerminal.map(value => value: java.lang.Boolean))(
        _.pseudoTerminal
      )
      .optionallyWith(
        dockerLabels.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.dockerLabels)
      .optionallyWith(
        ulimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ulimits)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(
        systemControls.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.systemControls)
      .optionallyWith(
        resourceRequirements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRequirements)
      .optionallyWith(
        firelensConfiguration.map(value => value.buildAwsValue())
      )(_.firelensConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ContainerDefinition.ReadOnly =
    zio.aws.ecs.model.ContainerDefinition.wrap(buildAwsValue())
}
object ContainerDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ContainerDefinition =
      zio.aws.ecs.model.ContainerDefinition(
        name.map(value => value),
        image.map(value => value),
        repositoryCredentials.map(value => value.asEditable),
        cpu.map(value => value),
        memory.map(value => value),
        memoryReservation.map(value => value),
        links.map(value => value),
        portMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        essential.map(value => value),
        entryPoint.map(value => value),
        command.map(value => value),
        environment.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        environmentFiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        volumesFrom.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        linuxParameters.map(value => value.asEditable),
        secrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dependsOn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        startTimeout.map(value => value),
        stopTimeout.map(value => value),
        hostname.map(value => value),
        user.map(value => value),
        workingDirectory.map(value => value),
        disableNetworking.map(value => value),
        privileged.map(value => value),
        readonlyRootFilesystem.map(value => value),
        dnsServers.map(value => value),
        dnsSearchDomains.map(value => value),
        extraHosts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dockerSecurityOptions.map(value => value),
        interactive.map(value => value),
        pseudoTerminal.map(value => value),
        dockerLabels.map(value => value),
        ulimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        logConfiguration.map(value => value.asEditable),
        healthCheck.map(value => value.asEditable),
        systemControls.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRequirements.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firelensConfiguration.map(value => value.asEditable)
      )
    def name: Optional[String]
    def image: Optional[String]
    def repositoryCredentials
        : Optional[zio.aws.ecs.model.RepositoryCredentials.ReadOnly]
    def cpu: Optional[Integer]
    def memory: Optional[BoxedInteger]
    def memoryReservation: Optional[BoxedInteger]
    def links: Optional[List[String]]
    def portMappings: Optional[List[zio.aws.ecs.model.PortMapping.ReadOnly]]
    def essential: Optional[BoxedBoolean]
    def entryPoint: Optional[List[String]]
    def command: Optional[List[String]]
    def environment: Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def environmentFiles
        : Optional[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]]
    def mountPoints: Optional[List[zio.aws.ecs.model.MountPoint.ReadOnly]]
    def volumesFrom: Optional[List[zio.aws.ecs.model.VolumeFrom.ReadOnly]]
    def linuxParameters: Optional[zio.aws.ecs.model.LinuxParameters.ReadOnly]
    def secrets: Optional[List[zio.aws.ecs.model.Secret.ReadOnly]]
    def dependsOn
        : Optional[List[zio.aws.ecs.model.ContainerDependency.ReadOnly]]
    def startTimeout: Optional[BoxedInteger]
    def stopTimeout: Optional[BoxedInteger]
    def hostname: Optional[String]
    def user: Optional[String]
    def workingDirectory: Optional[String]
    def disableNetworking: Optional[BoxedBoolean]
    def privileged: Optional[BoxedBoolean]
    def readonlyRootFilesystem: Optional[BoxedBoolean]
    def dnsServers: Optional[List[String]]
    def dnsSearchDomains: Optional[List[String]]
    def extraHosts: Optional[List[zio.aws.ecs.model.HostEntry.ReadOnly]]
    def dockerSecurityOptions: Optional[List[String]]
    def interactive: Optional[BoxedBoolean]
    def pseudoTerminal: Optional[BoxedBoolean]
    def dockerLabels: Optional[Map[String, String]]
    def ulimits: Optional[List[zio.aws.ecs.model.Ulimit.ReadOnly]]
    def logConfiguration: Optional[zio.aws.ecs.model.LogConfiguration.ReadOnly]
    def healthCheck: Optional[zio.aws.ecs.model.HealthCheck.ReadOnly]
    def systemControls: Optional[List[zio.aws.ecs.model.SystemControl.ReadOnly]]
    def resourceRequirements
        : Optional[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]]
    def firelensConfiguration
        : Optional[zio.aws.ecs.model.FirelensConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("image", image)
    def getRepositoryCredentials
        : ZIO[Any, AwsError, zio.aws.ecs.model.RepositoryCredentials.ReadOnly] =
      AwsError.unwrapOptionField("repositoryCredentials", repositoryCredentials)
    def getCpu: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memory", memory)
    def getMemoryReservation: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("memoryReservation", memoryReservation)
    def getLinks: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("links", links)
    def getPortMappings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.PortMapping.ReadOnly]] =
      AwsError.unwrapOptionField("portMappings", portMappings)
    def getEssential: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("essential", essential)
    def getEntryPoint: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getCommand: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("command", command)
    def getEnvironment
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("environment", environment)
    def getEnvironmentFiles
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      AwsError.unwrapOptionField("environmentFiles", environmentFiles)
    def getMountPoints
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.MountPoint.ReadOnly]] =
      AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getVolumesFrom
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.VolumeFrom.ReadOnly]] =
      AwsError.unwrapOptionField("volumesFrom", volumesFrom)
    def getLinuxParameters
        : ZIO[Any, AwsError, zio.aws.ecs.model.LinuxParameters.ReadOnly] =
      AwsError.unwrapOptionField("linuxParameters", linuxParameters)
    def getSecrets
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Secret.ReadOnly]] =
      AwsError.unwrapOptionField("secrets", secrets)
    def getDependsOn: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerDependency.ReadOnly
    ]] = AwsError.unwrapOptionField("dependsOn", dependsOn)
    def getStartTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("startTimeout", startTimeout)
    def getStopTimeout: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("stopTimeout", stopTimeout)
    def getHostname: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("user", user)
    def getWorkingDirectory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("workingDirectory", workingDirectory)
    def getDisableNetworking: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("disableNetworking", disableNetworking)
    def getPrivileged: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("privileged", privileged)
    def getReadonlyRootFilesystem: ZIO[Any, AwsError, BoxedBoolean] = AwsError
      .unwrapOptionField("readonlyRootFilesystem", readonlyRootFilesystem)
    def getDnsServers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getDnsSearchDomains: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dnsSearchDomains", dnsSearchDomains)
    def getExtraHosts
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.HostEntry.ReadOnly]] =
      AwsError.unwrapOptionField("extraHosts", extraHosts)
    def getDockerSecurityOptions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("dockerSecurityOptions", dockerSecurityOptions)
    def getInteractive: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getPseudoTerminal: ZIO[Any, AwsError, BoxedBoolean] =
      AwsError.unwrapOptionField("pseudoTerminal", pseudoTerminal)
    def getDockerLabels: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("dockerLabels", dockerLabels)
    def getUlimits
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Ulimit.ReadOnly]] =
      AwsError.unwrapOptionField("ulimits", ulimits)
    def getLogConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.LogConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("logConfiguration", logConfiguration)
    def getHealthCheck
        : ZIO[Any, AwsError, zio.aws.ecs.model.HealthCheck.ReadOnly] =
      AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getSystemControls
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.SystemControl.ReadOnly]] =
      AwsError.unwrapOptionField("systemControls", systemControls)
    def getResourceRequirements: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ResourceRequirement.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceRequirements", resourceRequirements)
    def getFirelensConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.FirelensConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("firelensConfiguration", firelensConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ) extends zio.aws.ecs.model.ContainerDefinition.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val image: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => value: String)
    override val repositoryCredentials
        : Optional[zio.aws.ecs.model.RepositoryCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.repositoryCredentials())
        .map(value => zio.aws.ecs.model.RepositoryCredentials.wrap(value))
    override val cpu: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: Integer)
    override val memory: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: BoxedInteger)
    override val memoryReservation: Optional[BoxedInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryReservation())
        .map(value => value: BoxedInteger)
    override val links: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.links())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val portMappings
        : Optional[List[zio.aws.ecs.model.PortMapping.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.portMappings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.PortMapping.wrap(item)
          }.toList
        )
    override val essential: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.essential())
      .map(value => value: BoxedBoolean)
    override val entryPoint: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.entryPoint())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val command: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val environment
        : Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.KeyValuePair.wrap(item)
          }.toList
        )
    override val environmentFiles
        : Optional[List[zio.aws.ecs.model.EnvironmentFile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environmentFiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.EnvironmentFile.wrap(item)
          }.toList
        )
    override val mountPoints
        : Optional[List[zio.aws.ecs.model.MountPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.MountPoint.wrap(item)
          }.toList
        )
    override val volumesFrom
        : Optional[List[zio.aws.ecs.model.VolumeFrom.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumesFrom())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.VolumeFrom.wrap(item)
          }.toList
        )
    override val linuxParameters
        : Optional[zio.aws.ecs.model.LinuxParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.linuxParameters())
        .map(value => zio.aws.ecs.model.LinuxParameters.wrap(value))
    override val secrets: Optional[List[zio.aws.ecs.model.Secret.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Secret.wrap(item)
          }.toList
        )
    override val dependsOn
        : Optional[List[zio.aws.ecs.model.ContainerDependency.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dependsOn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ContainerDependency.wrap(item)
          }.toList
        )
    override val startTimeout: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.startTimeout())
      .map(value => value: BoxedInteger)
    override val stopTimeout: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTimeout())
      .map(value => value: BoxedInteger)
    override val hostname: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hostname())
      .map(value => value: String)
    override val user: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => value: String)
    override val workingDirectory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.workingDirectory())
      .map(value => value: String)
    override val disableNetworking: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableNetworking())
        .map(value => value: BoxedBoolean)
    override val privileged: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: BoxedBoolean)
    override val readonlyRootFilesystem: Optional[BoxedBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readonlyRootFilesystem())
        .map(value => value: BoxedBoolean)
    override val dnsServers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsServers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dnsSearchDomains: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsSearchDomains())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val extraHosts
        : Optional[List[zio.aws.ecs.model.HostEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extraHosts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.HostEntry.wrap(item)
          }.toList
        )
    override val dockerSecurityOptions: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerSecurityOptions())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val interactive: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.interactive())
      .map(value => value: BoxedBoolean)
    override val pseudoTerminal: Optional[BoxedBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.pseudoTerminal())
      .map(value => value: BoxedBoolean)
    override val dockerLabels: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dockerLabels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val ulimits: Optional[List[zio.aws.ecs.model.Ulimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ulimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Ulimit.wrap(item)
          }.toList
        )
    override val logConfiguration
        : Optional[zio.aws.ecs.model.LogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value => zio.aws.ecs.model.LogConfiguration.wrap(value))
    override val healthCheck: Optional[zio.aws.ecs.model.HealthCheck.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheck())
        .map(value => zio.aws.ecs.model.HealthCheck.wrap(value))
    override val systemControls
        : Optional[List[zio.aws.ecs.model.SystemControl.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemControls())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.SystemControl.wrap(item)
          }.toList
        )
    override val resourceRequirements
        : Optional[List[zio.aws.ecs.model.ResourceRequirement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRequirements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ResourceRequirement.wrap(item)
          }.toList
        )
    override val firelensConfiguration
        : Optional[zio.aws.ecs.model.FirelensConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firelensConfiguration())
        .map(value => zio.aws.ecs.model.FirelensConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ContainerDefinition
  ): zio.aws.ecs.model.ContainerDefinition.ReadOnly = new Wrapper(impl)
}
