package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateClusterSettingsResponse(
    cluster: Optional[zio.aws.ecs.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse = {
    import UpdateClusterSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly =
    zio.aws.ecs.model.UpdateClusterSettingsResponse.wrap(buildAwsValue())
}
object UpdateClusterSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateClusterSettingsResponse =
      zio.aws.ecs.model
        .UpdateClusterSettingsResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.ecs.model.Cluster.ReadOnly]
    def getCluster: ZIO[Any, AwsError, zio.aws.ecs.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse
  ) extends zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly {
    override val cluster: Optional[zio.aws.ecs.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.ecs.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterSettingsResponse
  ): zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly = new Wrapper(
    impl
  )
}
