package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskOverride(
    containerOverrides: Optional[
      Iterable[zio.aws.ecs.model.ContainerOverride]
    ] = Optional.Absent,
    cpu: Optional[String] = Optional.Absent,
    inferenceAcceleratorOverrides: Optional[
      Iterable[zio.aws.ecs.model.InferenceAcceleratorOverride]
    ] = Optional.Absent,
    executionRoleArn: Optional[String] = Optional.Absent,
    memory: Optional[String] = Optional.Absent,
    taskRoleArn: Optional[String] = Optional.Absent,
    ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.TaskOverride = {
    import TaskOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.TaskOverride
      .builder()
      .optionallyWith(
        containerOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containerOverrides)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(
        inferenceAcceleratorOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAcceleratorOverrides)
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(taskRoleArn.map(value => value: java.lang.String))(
        _.taskRoleArn
      )
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.TaskOverride.ReadOnly =
    zio.aws.ecs.model.TaskOverride.wrap(buildAwsValue())
}
object TaskOverride {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.TaskOverride] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.TaskOverride =
      zio.aws.ecs.model.TaskOverride(
        containerOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cpu.map(value => value),
        inferenceAcceleratorOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        executionRoleArn.map(value => value),
        memory.map(value => value),
        taskRoleArn.map(value => value),
        ephemeralStorage.map(value => value.asEditable)
      )
    def containerOverrides
        : Optional[List[zio.aws.ecs.model.ContainerOverride.ReadOnly]]
    def cpu: Optional[String]
    def inferenceAcceleratorOverrides: Optional[
      List[zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly]
    ]
    def executionRoleArn: Optional[String]
    def memory: Optional[String]
    def taskRoleArn: Optional[String]
    def ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def getContainerOverrides: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("containerOverrides", containerOverrides)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getInferenceAcceleratorOverrides: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "inferenceAcceleratorOverrides",
      inferenceAcceleratorOverrides
    )
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getTaskRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.TaskOverride
  ) extends zio.aws.ecs.model.TaskOverride.ReadOnly {
    override val containerOverrides
        : Optional[List[zio.aws.ecs.model.ContainerOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ContainerOverride.wrap(item)
          }.toList
        )
    override val cpu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: String)
    override val inferenceAcceleratorOverrides: Optional[
      List[zio.aws.ecs.model.InferenceAcceleratorOverride.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inferenceAcceleratorOverrides())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.InferenceAcceleratorOverride.wrap(item)
        }.toList
      )
    override val executionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => value: String)
    override val memory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: String)
    override val taskRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRoleArn())
      .map(value => value: String)
    override val ephemeralStorage
        : Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.TaskOverride
  ): zio.aws.ecs.model.TaskOverride.ReadOnly = new Wrapper(impl)
}
