package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SubmitContainerStateChangeResponse(
    acknowledgment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse = {
    import SubmitContainerStateChangeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse
      .builder()
      .optionallyWith(acknowledgment.map(value => value: java.lang.String))(
        _.acknowledgment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly =
    zio.aws.ecs.model.SubmitContainerStateChangeResponse.wrap(buildAwsValue())
}
object SubmitContainerStateChangeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitContainerStateChangeResponse =
      zio.aws.ecs.model
        .SubmitContainerStateChangeResponse(acknowledgment.map(value => value))
    def acknowledgment: Optional[String]
    def getAcknowledgment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("acknowledgment", acknowledgment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse
  ) extends zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly {
    override val acknowledgment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.acknowledgment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeResponse
  ): zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly =
    new Wrapper(impl)
}
