package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionsResponse(
    taskDefinitionArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse = {
    import ListTaskDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse
      .builder()
      .optionallyWith(
        taskDefinitionArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.taskDefinitionArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionsResponse.wrap(buildAwsValue())
}
object ListTaskDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionsResponse =
      zio.aws.ecs.model.ListTaskDefinitionsResponse(
        taskDefinitionArns.map(value => value),
        nextToken.map(value => value)
      )
    def taskDefinitionArns: Optional[List[String]]
    def nextToken: Optional[String]
    def getTaskDefinitionArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("taskDefinitionArns", taskDefinitionArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse
  ) extends zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly {
    override val taskDefinitionArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinitionArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionsResponse
  ): zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly = new Wrapper(impl)
}
