package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ContainerInstanceStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus
}
object ContainerInstanceStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus
  ): zio.aws.ecs.model.ContainerInstanceStatus = value match {
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.DRAINING =>
      val r = DRAINING
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.REGISTERING =>
      val r = REGISTERING
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.DEREGISTERING =>
      val r = DEREGISTERING
      r
    case software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.REGISTRATION_FAILED =>
      val r = REGISTRATION_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.ACTIVE
  }
  case object DRAINING extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.DRAINING
  }
  case object REGISTERING extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.REGISTERING
  }
  case object DEREGISTERING extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.DEREGISTERING
  }
  case object REGISTRATION_FAILED
      extends zio.aws.ecs.model.ContainerInstanceStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus =
      software.amazon.awssdk.services.ecs.model.ContainerInstanceStatus.REGISTRATION_FAILED
  }
}
