package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAttributesRequest(
    cluster: Optional[String] = Optional.Absent,
    targetType: zio.aws.ecs.model.TargetType,
    attributeName: Optional[String] = Optional.Absent,
    attributeValue: Optional[String] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[BoxedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListAttributesRequest = {
    import ListAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListAttributesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .targetType(targetType.unwrap)
      .optionallyWith(attributeName.map(value => value: java.lang.String))(
        _.attributeName
      )
      .optionallyWith(attributeValue.map(value => value: java.lang.String))(
        _.attributeValue
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListAttributesRequest.ReadOnly =
    zio.aws.ecs.model.ListAttributesRequest.wrap(buildAwsValue())
}
object ListAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListAttributesRequest =
      zio.aws.ecs.model.ListAttributesRequest(
        cluster.map(value => value),
        targetType,
        attributeName.map(value => value),
        attributeValue.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def cluster: Optional[String]
    def targetType: zio.aws.ecs.model.TargetType
    def attributeName: Optional[String]
    def attributeValue: Optional[String]
    def nextToken: Optional[String]
    def maxResults: Optional[BoxedInteger]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTargetType: ZIO[Any, Nothing, zio.aws.ecs.model.TargetType] =
      ZIO.succeed(targetType)
    def getAttributeName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ) extends zio.aws.ecs.model.ListAttributesRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val targetType: zio.aws.ecs.model.TargetType =
      zio.aws.ecs.model.TargetType.wrap(impl.targetType())
    override val attributeName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => value: String)
    override val attributeValue: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeValue())
      .map(value => value: String)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: BoxedInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListAttributesRequest
  ): zio.aws.ecs.model.ListAttributesRequest.ReadOnly = new Wrapper(impl)
}
