package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait HealthStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.HealthStatus
}
object HealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.HealthStatus
  ): zio.aws.ecs.model.HealthStatus = value match {
    case software.amazon.awssdk.services.ecs.model.HealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.HealthStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.ecs.model.HealthStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
    case software.amazon.awssdk.services.ecs.model.HealthStatus.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.HealthStatus =
      software.amazon.awssdk.services.ecs.model.HealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.ecs.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.HealthStatus =
      software.amazon.awssdk.services.ecs.model.HealthStatus.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.ecs.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.HealthStatus =
      software.amazon.awssdk.services.ecs.model.HealthStatus.UNHEALTHY
  }
  case object UNKNOWN extends zio.aws.ecs.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.HealthStatus =
      software.amazon.awssdk.services.ecs.model.HealthStatus.UNKNOWN
  }
}
