package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteCommandConfiguration(
    kmsKeyId: Optional[String] = Optional.Absent,
    logging: Optional[zio.aws.ecs.model.ExecuteCommandLogging] =
      Optional.Absent,
    logConfiguration: Optional[
      zio.aws.ecs.model.ExecuteCommandLogConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ExecuteCommandConfiguration = {
    import ExecuteCommandConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ExecuteCommandConfiguration
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(logging.map(value => value.unwrap))(_.logging)
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly =
    zio.aws.ecs.model.ExecuteCommandConfiguration.wrap(buildAwsValue())
}
object ExecuteCommandConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ExecuteCommandConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ExecuteCommandConfiguration =
      zio.aws.ecs.model.ExecuteCommandConfiguration(
        kmsKeyId.map(value => value),
        logging.map(value => value),
        logConfiguration.map(value => value.asEditable)
      )
    def kmsKeyId: Optional[String]
    def logging: Optional[zio.aws.ecs.model.ExecuteCommandLogging]
    def logConfiguration
        : Optional[zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getLogging
        : ZIO[Any, AwsError, zio.aws.ecs.model.ExecuteCommandLogging] =
      AwsError.unwrapOptionField("logging", logging)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandConfiguration
  ) extends zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val logging: Optional[zio.aws.ecs.model.ExecuteCommandLogging] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logging())
        .map(value => zio.aws.ecs.model.ExecuteCommandLogging.wrap(value))
    override val logConfiguration
        : Optional[zio.aws.ecs.model.ExecuteCommandLogConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value =>
          zio.aws.ecs.model.ExecuteCommandLogConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandConfiguration
  ): zio.aws.ecs.model.ExecuteCommandConfiguration.ReadOnly = new Wrapper(impl)
}
