package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VersionInfo(
    agentVersion: Optional[String] = Optional.Absent,
    agentHash: Optional[String] = Optional.Absent,
    dockerVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.VersionInfo = {
    import VersionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.VersionInfo
      .builder()
      .optionallyWith(agentVersion.map(value => value: java.lang.String))(
        _.agentVersion
      )
      .optionallyWith(agentHash.map(value => value: java.lang.String))(
        _.agentHash
      )
      .optionallyWith(dockerVersion.map(value => value: java.lang.String))(
        _.dockerVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.VersionInfo.ReadOnly =
    zio.aws.ecs.model.VersionInfo.wrap(buildAwsValue())
}
object VersionInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.VersionInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.VersionInfo =
      zio.aws.ecs.model.VersionInfo(
        agentVersion.map(value => value),
        agentHash.map(value => value),
        dockerVersion.map(value => value)
      )
    def agentVersion: Optional[String]
    def agentHash: Optional[String]
    def dockerVersion: Optional[String]
    def getAgentVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("agentVersion", agentVersion)
    def getAgentHash: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("agentHash", agentHash)
    def getDockerVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dockerVersion", dockerVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.VersionInfo
  ) extends zio.aws.ecs.model.VersionInfo.ReadOnly {
    override val agentVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.agentVersion())
      .map(value => value: String)
    override val agentHash: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.agentHash())
      .map(value => value: String)
    override val dockerVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dockerVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.VersionInfo
  ): zio.aws.ecs.model.VersionInfo.ReadOnly = new Wrapper(impl)
}
