package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait DeploymentControllerType {
  def unwrap: software.amazon.awssdk.services.ecs.model.DeploymentControllerType
}
object DeploymentControllerType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.DeploymentControllerType
  ): zio.aws.ecs.model.DeploymentControllerType = value match {
    case software.amazon.awssdk.services.ecs.model.DeploymentControllerType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentControllerType.ECS =>
      val r = ECS
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentControllerType.CODE_DEPLOY =>
      val r = CODE_DEPLOY
      r
    case software.amazon.awssdk.services.ecs.model.DeploymentControllerType.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.DeploymentControllerType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentControllerType =
      software.amazon.awssdk.services.ecs.model.DeploymentControllerType.UNKNOWN_TO_SDK_VERSION
  }
  case object ECS extends zio.aws.ecs.model.DeploymentControllerType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentControllerType =
      software.amazon.awssdk.services.ecs.model.DeploymentControllerType.ECS
  }
  case object CODE_DEPLOY extends zio.aws.ecs.model.DeploymentControllerType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentControllerType =
      software.amazon.awssdk.services.ecs.model.DeploymentControllerType.CODE_DEPLOY
  }
  case object EXTERNAL extends zio.aws.ecs.model.DeploymentControllerType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.DeploymentControllerType =
      software.amazon.awssdk.services.ecs.model.DeploymentControllerType.EXTERNAL
  }
}
