package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CapacityProvider(
    capacityProviderArn: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.ecs.model.CapacityProviderStatus] =
      Optional.Absent,
    autoScalingGroupProvider: Optional[
      zio.aws.ecs.model.AutoScalingGroupProvider
    ] = Optional.Absent,
    updateStatus: Optional[zio.aws.ecs.model.CapacityProviderUpdateStatus] =
      Optional.Absent,
    updateStatusReason: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CapacityProvider = {
    import CapacityProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CapacityProvider
      .builder()
      .optionallyWith(
        capacityProviderArn.map(value => value: java.lang.String)
      )(_.capacityProviderArn)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        autoScalingGroupProvider.map(value => value.buildAwsValue())
      )(_.autoScalingGroupProvider)
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(updateStatusReason.map(value => value: java.lang.String))(
        _.updateStatusReason
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CapacityProvider.ReadOnly =
    zio.aws.ecs.model.CapacityProvider.wrap(buildAwsValue())
}
object CapacityProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CapacityProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CapacityProvider =
      zio.aws.ecs.model.CapacityProvider(
        capacityProviderArn.map(value => value),
        name.map(value => value),
        status.map(value => value),
        autoScalingGroupProvider.map(value => value.asEditable),
        updateStatus.map(value => value),
        updateStatusReason.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def capacityProviderArn: Optional[String]
    def name: Optional[String]
    def status: Optional[zio.aws.ecs.model.CapacityProviderStatus]
    def autoScalingGroupProvider
        : Optional[zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly]
    def updateStatus: Optional[zio.aws.ecs.model.CapacityProviderUpdateStatus]
    def updateStatusReason: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def getCapacityProviderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("capacityProviderArn", capacityProviderArn)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProviderStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAutoScalingGroupProvider: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly
    ] = AwsError.unwrapOptionField(
      "autoScalingGroupProvider",
      autoScalingGroupProvider
    )
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.ecs.model.CapacityProviderUpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getUpdateStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("updateStatusReason", updateStatusReason)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProvider
  ) extends zio.aws.ecs.model.CapacityProvider.ReadOnly {
    override val capacityProviderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityProviderArn())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val status: Optional[zio.aws.ecs.model.CapacityProviderStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ecs.model.CapacityProviderStatus.wrap(value))
    override val autoScalingGroupProvider
        : Optional[zio.aws.ecs.model.AutoScalingGroupProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingGroupProvider())
        .map(value => zio.aws.ecs.model.AutoScalingGroupProvider.wrap(value))
    override val updateStatus
        : Optional[zio.aws.ecs.model.CapacityProviderUpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value =>
          zio.aws.ecs.model.CapacityProviderUpdateStatus.wrap(value)
        )
    override val updateStatusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.updateStatusReason())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CapacityProvider
  ): zio.aws.ecs.model.CapacityProvider.ReadOnly = new Wrapper(impl)
}
