package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterTaskDefinitionRequest(
    family: String,
    taskRoleArn: Optional[String] = Optional.Absent,
    executionRoleArn: Optional[String] = Optional.Absent,
    networkMode: Optional[zio.aws.ecs.model.NetworkMode] = Optional.Absent,
    containerDefinitions: Iterable[zio.aws.ecs.model.ContainerDefinition],
    volumes: Optional[Iterable[zio.aws.ecs.model.Volume]] = Optional.Absent,
    placementConstraints: Optional[
      Iterable[zio.aws.ecs.model.TaskDefinitionPlacementConstraint]
    ] = Optional.Absent,
    requiresCompatibilities: Optional[
      Iterable[zio.aws.ecs.model.Compatibility]
    ] = Optional.Absent,
    cpu: Optional[String] = Optional.Absent,
    memory: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ecs.model.Tag]] = Optional.Absent,
    pidMode: Optional[zio.aws.ecs.model.PidMode] = Optional.Absent,
    ipcMode: Optional[zio.aws.ecs.model.IpcMode] = Optional.Absent,
    proxyConfiguration: Optional[zio.aws.ecs.model.ProxyConfiguration] =
      Optional.Absent,
    inferenceAccelerators: Optional[
      Iterable[zio.aws.ecs.model.InferenceAccelerator]
    ] = Optional.Absent,
    ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage] =
      Optional.Absent,
    runtimePlatform: Optional[zio.aws.ecs.model.RuntimePlatform] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest = {
    import RegisterTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest
      .builder()
      .family(family: java.lang.String)
      .optionallyWith(taskRoleArn.map(value => value: java.lang.String))(
        _.taskRoleArn
      )
      .optionallyWith(executionRoleArn.map(value => value: java.lang.String))(
        _.executionRoleArn
      )
      .optionallyWith(networkMode.map(value => value.unwrap))(_.networkMode)
      .containerDefinitions(containerDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        requiresCompatibilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.requiresCompatibilitiesWithStrings)
      .optionallyWith(cpu.map(value => value: java.lang.String))(_.cpu)
      .optionallyWith(memory.map(value => value: java.lang.String))(_.memory)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(pidMode.map(value => value.unwrap))(_.pidMode)
      .optionallyWith(ipcMode.map(value => value.unwrap))(_.ipcMode)
      .optionallyWith(proxyConfiguration.map(value => value.buildAwsValue()))(
        _.proxyConfiguration
      )
      .optionallyWith(
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inferenceAccelerators)
      .optionallyWith(ephemeralStorage.map(value => value.buildAwsValue()))(
        _.ephemeralStorage
      )
      .optionallyWith(runtimePlatform.map(value => value.buildAwsValue()))(
        _.runtimePlatform
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RegisterTaskDefinitionRequest.ReadOnly =
    zio.aws.ecs.model.RegisterTaskDefinitionRequest.wrap(buildAwsValue())
}
object RegisterTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RegisterTaskDefinitionRequest =
      zio.aws.ecs.model.RegisterTaskDefinitionRequest(
        family,
        taskRoleArn.map(value => value),
        executionRoleArn.map(value => value),
        networkMode.map(value => value),
        containerDefinitions.map { item =>
          item.asEditable
        },
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        placementConstraints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        requiresCompatibilities.map(value => value),
        cpu.map(value => value),
        memory.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pidMode.map(value => value),
        ipcMode.map(value => value),
        proxyConfiguration.map(value => value.asEditable),
        inferenceAccelerators.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ephemeralStorage.map(value => value.asEditable),
        runtimePlatform.map(value => value.asEditable)
      )
    def family: String
    def taskRoleArn: Optional[String]
    def executionRoleArn: Optional[String]
    def networkMode: Optional[zio.aws.ecs.model.NetworkMode]
    def containerDefinitions
        : List[zio.aws.ecs.model.ContainerDefinition.ReadOnly]
    def volumes: Optional[List[zio.aws.ecs.model.Volume.ReadOnly]]
    def placementConstraints: Optional[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ]
    def requiresCompatibilities: Optional[List[zio.aws.ecs.model.Compatibility]]
    def cpu: Optional[String]
    def memory: Optional[String]
    def tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def pidMode: Optional[zio.aws.ecs.model.PidMode]
    def ipcMode: Optional[zio.aws.ecs.model.IpcMode]
    def proxyConfiguration
        : Optional[zio.aws.ecs.model.ProxyConfiguration.ReadOnly]
    def inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]]
    def ephemeralStorage: Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly]
    def runtimePlatform: Optional[zio.aws.ecs.model.RuntimePlatform.ReadOnly]
    def getFamily: ZIO[Any, Nothing, String] = ZIO.succeed(family)
    def getTaskRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskRoleArn", taskRoleArn)
    def getExecutionRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getNetworkMode: ZIO[Any, AwsError, zio.aws.ecs.model.NetworkMode] =
      AwsError.unwrapOptionField("networkMode", networkMode)
    def getContainerDefinitions: ZIO[Any, Nothing, List[
      zio.aws.ecs.model.ContainerDefinition.ReadOnly
    ]] = ZIO.succeed(containerDefinitions)
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getRequiresCompatibilities
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Compatibility]] = AwsError
      .unwrapOptionField("requiresCompatibilities", requiresCompatibilities)
    def getCpu: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cpu", cpu)
    def getMemory: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("memory", memory)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPidMode: ZIO[Any, AwsError, zio.aws.ecs.model.PidMode] =
      AwsError.unwrapOptionField("pidMode", pidMode)
    def getIpcMode: ZIO[Any, AwsError, zio.aws.ecs.model.IpcMode] =
      AwsError.unwrapOptionField("ipcMode", ipcMode)
    def getProxyConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ProxyConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("proxyConfiguration", proxyConfiguration)
    def getInferenceAccelerators: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.InferenceAccelerator.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inferenceAccelerators", inferenceAccelerators)
    def getEphemeralStorage
        : ZIO[Any, AwsError, zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      AwsError.unwrapOptionField("ephemeralStorage", ephemeralStorage)
    def getRuntimePlatform
        : ZIO[Any, AwsError, zio.aws.ecs.model.RuntimePlatform.ReadOnly] =
      AwsError.unwrapOptionField("runtimePlatform", runtimePlatform)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest
  ) extends zio.aws.ecs.model.RegisterTaskDefinitionRequest.ReadOnly {
    override val family: String = impl.family(): String
    override val taskRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskRoleArn())
      .map(value => value: String)
    override val executionRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executionRoleArn())
      .map(value => value: String)
    override val networkMode: Optional[zio.aws.ecs.model.NetworkMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkMode())
        .map(value => zio.aws.ecs.model.NetworkMode.wrap(value))
    override val containerDefinitions
        : List[zio.aws.ecs.model.ContainerDefinition.ReadOnly] = impl
      .containerDefinitions()
      .asScala
      .map { item =>
        zio.aws.ecs.model.ContainerDefinition.wrap(item)
      }
      .toList
    override val volumes: Optional[List[zio.aws.ecs.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Volume.wrap(item)
          }.toList
        )
    override val placementConstraints: Optional[
      List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.TaskDefinitionPlacementConstraint.wrap(item)
        }.toList
      )
    override val requiresCompatibilities
        : Optional[List[zio.aws.ecs.model.Compatibility]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requiresCompatibilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Compatibility.wrap(item)
          }.toList
        )
    override val cpu: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cpu())
      .map(value => value: String)
    override val memory: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.memory())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ecs.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Tag.wrap(item)
          }.toList
        )
    override val pidMode: Optional[zio.aws.ecs.model.PidMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pidMode())
        .map(value => zio.aws.ecs.model.PidMode.wrap(value))
    override val ipcMode: Optional[zio.aws.ecs.model.IpcMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipcMode())
        .map(value => zio.aws.ecs.model.IpcMode.wrap(value))
    override val proxyConfiguration
        : Optional[zio.aws.ecs.model.ProxyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxyConfiguration())
        .map(value => zio.aws.ecs.model.ProxyConfiguration.wrap(value))
    override val inferenceAccelerators
        : Optional[List[zio.aws.ecs.model.InferenceAccelerator.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inferenceAccelerators())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.InferenceAccelerator.wrap(item)
          }.toList
        )
    override val ephemeralStorage
        : Optional[zio.aws.ecs.model.EphemeralStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ephemeralStorage())
        .map(value => zio.aws.ecs.model.EphemeralStorage.wrap(value))
    override val runtimePlatform
        : Optional[zio.aws.ecs.model.RuntimePlatform.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimePlatform())
        .map(value => zio.aws.ecs.model.RuntimePlatform.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RegisterTaskDefinitionRequest
  ): zio.aws.ecs.model.RegisterTaskDefinitionRequest.ReadOnly = new Wrapper(
    impl
  )
}
