package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ProxyConfiguration(
    `type`: Optional[zio.aws.ecs.model.ProxyConfigurationType] =
      Optional.Absent,
    containerName: String,
    properties: Optional[Iterable[zio.aws.ecs.model.KeyValuePair]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ProxyConfiguration = {
    import ProxyConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ProxyConfiguration
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .containerName(containerName: java.lang.String)
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ProxyConfiguration.ReadOnly =
    zio.aws.ecs.model.ProxyConfiguration.wrap(buildAwsValue())
}
object ProxyConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ProxyConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ProxyConfiguration =
      zio.aws.ecs.model.ProxyConfiguration(
        `type`.map(value => value),
        containerName,
        properties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: Optional[zio.aws.ecs.model.ProxyConfigurationType]
    def containerName: String
    def properties: Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]]
    def getType: ZIO[Any, AwsError, zio.aws.ecs.model.ProxyConfigurationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getContainerName: ZIO[Any, Nothing, String] = ZIO.succeed(containerName)
    def getProperties
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      AwsError.unwrapOptionField("properties", properties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ProxyConfiguration
  ) extends zio.aws.ecs.model.ProxyConfiguration.ReadOnly {
    override val `type`: Optional[zio.aws.ecs.model.ProxyConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ecs.model.ProxyConfigurationType.wrap(value))
    override val containerName: String = impl.containerName(): String
    override val properties
        : Optional[List[zio.aws.ecs.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.properties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.KeyValuePair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ProxyConfiguration
  ): zio.aws.ecs.model.ProxyConfiguration.ReadOnly = new Wrapper(impl)
}
