package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTasksResponse(
    taskArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTasksResponse = {
    import ListTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTasksResponse
      .builder()
      .optionallyWith(
        taskArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.taskArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTasksResponse.ReadOnly =
    zio.aws.ecs.model.ListTasksResponse.wrap(buildAwsValue())
}
object ListTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTasksResponse =
      zio.aws.ecs.model.ListTasksResponse(
        taskArns.map(value => value),
        nextToken.map(value => value)
      )
    def taskArns: Optional[List[String]]
    def nextToken: Optional[String]
    def getTaskArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("taskArns", taskArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ) extends zio.aws.ecs.model.ListTasksResponse.ReadOnly {
    override val taskArns: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ): zio.aws.ecs.model.ListTasksResponse.ReadOnly = new Wrapper(impl)
}
