package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContainerInstancesResponse(
    containerInstanceArns: Optional[Iterable[String]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse = {
    import ListContainerInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse
      .builder()
      .optionallyWith(
        containerInstanceArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.containerInstanceArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly =
    zio.aws.ecs.model.ListContainerInstancesResponse.wrap(buildAwsValue())
}
object ListContainerInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListContainerInstancesResponse =
      zio.aws.ecs.model.ListContainerInstancesResponse(
        containerInstanceArns.map(value => value),
        nextToken.map(value => value)
      )
    def containerInstanceArns: Optional[List[String]]
    def nextToken: Optional[String]
    def getContainerInstanceArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("containerInstanceArns", containerInstanceArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse
  ) extends zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly {
    override val containerInstanceArns: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.containerInstanceArns())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListContainerInstancesResponse
  ): zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
