package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiscoverPollEndpointResponse(
    endpoint: Optional[String] = Optional.Absent,
    telemetryEndpoint: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse = {
    import DiscoverPollEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse
      .builder()
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(telemetryEndpoint.map(value => value: java.lang.String))(
        _.telemetryEndpoint
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly =
    zio.aws.ecs.model.DiscoverPollEndpointResponse.wrap(buildAwsValue())
}
object DiscoverPollEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DiscoverPollEndpointResponse =
      zio.aws.ecs.model.DiscoverPollEndpointResponse(
        endpoint.map(value => value),
        telemetryEndpoint.map(value => value)
      )
    def endpoint: Optional[String]
    def telemetryEndpoint: Optional[String]
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getTelemetryEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("telemetryEndpoint", telemetryEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse
  ) extends zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly {
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val telemetryEndpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.telemetryEndpoint())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DiscoverPollEndpointResponse
  ): zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly = new Wrapper(impl)
}
