package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeServicesRequest(
    cluster: Optional[String] = Optional.Absent,
    services: Iterable[String],
    include: Optional[Iterable[zio.aws.ecs.model.ServiceField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeServicesRequest = {
    import DescribeServicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeServicesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .services(services.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeServicesRequest.ReadOnly =
    zio.aws.ecs.model.DescribeServicesRequest.wrap(buildAwsValue())
}
object DescribeServicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeServicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeServicesRequest =
      zio.aws.ecs.model.DescribeServicesRequest(
        cluster.map(value => value),
        services,
        include.map(value => value)
      )
    def cluster: Optional[String]
    def services: List[String]
    def include: Optional[List[zio.aws.ecs.model.ServiceField]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getServices: ZIO[Any, Nothing, List[String]] = ZIO.succeed(services)
    def getInclude: ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeServicesRequest
  ) extends zio.aws.ecs.model.DescribeServicesRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val services: List[String] = impl
      .services()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val include: Optional[List[zio.aws.ecs.model.ServiceField]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeServicesRequest
  ): zio.aws.ecs.model.DescribeServicesRequest.ReadOnly = new Wrapper(impl)
}
