package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait StabilityStatus {
  def unwrap: software.amazon.awssdk.services.ecs.model.StabilityStatus
}
object StabilityStatus {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.StabilityStatus
  ): zio.aws.ecs.model.StabilityStatus = value match {
    case software.amazon.awssdk.services.ecs.model.StabilityStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.StabilityStatus.STEADY_STATE =>
      val r = STEADY_STATE
      r
    case software.amazon.awssdk.services.ecs.model.StabilityStatus.STABILIZING =>
      val r = STABILIZING
      r
  }
  case object unknownToSdkVersion extends zio.aws.ecs.model.StabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.StabilityStatus =
      software.amazon.awssdk.services.ecs.model.StabilityStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STEADY_STATE extends zio.aws.ecs.model.StabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.StabilityStatus =
      software.amazon.awssdk.services.ecs.model.StabilityStatus.STEADY_STATE
  }
  case object STABILIZING extends zio.aws.ecs.model.StabilityStatus {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.StabilityStatus =
      software.amazon.awssdk.services.ecs.model.StabilityStatus.STABILIZING
  }
}
