package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteCommandResponse(
    clusterArn: Optional[String] = Optional.Absent,
    containerArn: Optional[String] = Optional.Absent,
    containerName: Optional[String] = Optional.Absent,
    interactive: Optional[Boolean] = Optional.Absent,
    session: Optional[zio.aws.ecs.model.Session] = Optional.Absent,
    taskArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse = {
    import ExecuteCommandResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(containerArn.map(value => value: java.lang.String))(
        _.containerArn
      )
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(interactive.map(value => value: java.lang.Boolean))(
        _.interactive
      )
      .optionallyWith(session.map(value => value.buildAwsValue()))(_.session)
      .optionallyWith(taskArn.map(value => value: java.lang.String))(_.taskArn)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly =
    zio.aws.ecs.model.ExecuteCommandResponse.wrap(buildAwsValue())
}
object ExecuteCommandResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ExecuteCommandResponse =
      zio.aws.ecs.model.ExecuteCommandResponse(
        clusterArn.map(value => value),
        containerArn.map(value => value),
        containerName.map(value => value),
        interactive.map(value => value),
        session.map(value => value.asEditable),
        taskArn.map(value => value)
      )
    def clusterArn: Optional[String]
    def containerArn: Optional[String]
    def containerName: Optional[String]
    def interactive: Optional[Boolean]
    def session: Optional[zio.aws.ecs.model.Session.ReadOnly]
    def taskArn: Optional[String]
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getContainerArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerArn", containerArn)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getInteractive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("interactive", interactive)
    def getSession: ZIO[Any, AwsError, zio.aws.ecs.model.Session.ReadOnly] =
      AwsError.unwrapOptionField("session", session)
    def getTaskArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskArn", taskArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ) extends zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly {
    override val clusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: String)
    override val containerArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerArn())
      .map(value => value: String)
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val interactive: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.interactive())
      .map(value => value: Boolean)
    override val session: Optional[zio.aws.ecs.model.Session.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.session())
        .map(value => zio.aws.ecs.model.Session.wrap(value))
    override val taskArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ExecuteCommandResponse
  ): zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly = new Wrapper(impl)
}
