package zio.aws.ecs
import zio.aws.ecs.model.primitives.TagKey
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.ecs.model.primitives.Timestamp.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    type BoxedBoolean = Boolean
    type BoxedInteger = Int
    object CapacityProviderStrategyItemBase extends Subtype[Int]
    type CapacityProviderStrategyItemBase =
      zio.aws.ecs.model.primitives.CapacityProviderStrategyItemBase.Type
    object CapacityProviderStrategyItemWeight extends Subtype[Int]
    type CapacityProviderStrategyItemWeight =
      zio.aws.ecs.model.primitives.CapacityProviderStrategyItemWeight.Type
    type Integer = Int
    object ManagedScalingInstanceWarmupPeriod extends Subtype[Int]
    type ManagedScalingInstanceWarmupPeriod =
      zio.aws.ecs.model.primitives.ManagedScalingInstanceWarmupPeriod.Type
    object ManagedScalingStepSize extends Subtype[Int]
    type ManagedScalingStepSize =
      zio.aws.ecs.model.primitives.ManagedScalingStepSize.Type
    object ManagedScalingTargetCapacity extends Subtype[Int]
    type ManagedScalingTargetCapacity =
      zio.aws.ecs.model.primitives.ManagedScalingTargetCapacity.Type
    object SensitiveString extends Subtype[String]
    type SensitiveString = zio.aws.ecs.model.primitives.SensitiveString.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ecs.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ecs.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.ecs.model.primitives.Timestamp.Type
  }
  type AttachmentDetails = List[zio.aws.ecs.model.KeyValuePair]
  type AttachmentStateChanges = List[zio.aws.ecs.model.AttachmentStateChange]
  type Attachments = List[zio.aws.ecs.model.Attachment]
  type Attributes = List[zio.aws.ecs.model.Attribute]
  type CapacityProviderFieldList = List[zio.aws.ecs.model.CapacityProviderField]
  type CapacityProviderStrategy =
    List[zio.aws.ecs.model.CapacityProviderStrategyItem]
  type CapacityProviders = List[zio.aws.ecs.model.CapacityProvider]
  type ClusterFieldList = List[zio.aws.ecs.model.ClusterField]
  type ClusterSettings = List[zio.aws.ecs.model.ClusterSetting]
  type Clusters = List[zio.aws.ecs.model.Cluster]
  type CompatibilityList = List[zio.aws.ecs.model.Compatibility]
  type ContainerDefinitions = List[zio.aws.ecs.model.ContainerDefinition]
  type ContainerDependencies = List[zio.aws.ecs.model.ContainerDependency]
  type ContainerInstanceFieldList =
    List[zio.aws.ecs.model.ContainerInstanceField]
  type ContainerInstances = List[zio.aws.ecs.model.ContainerInstance]
  type ContainerOverrides = List[zio.aws.ecs.model.ContainerOverride]
  type ContainerStateChanges = List[zio.aws.ecs.model.ContainerStateChange]
  type Containers = List[zio.aws.ecs.model.Container]
  type Deployments = List[zio.aws.ecs.model.Deployment]
  type DeviceCgroupPermissions = List[zio.aws.ecs.model.DeviceCgroupPermission]
  type DevicesList = List[zio.aws.ecs.model.Device]
  type DockerLabelsMap = Map[String, String]
  type EnvironmentFiles = List[zio.aws.ecs.model.EnvironmentFile]
  type EnvironmentVariables = List[zio.aws.ecs.model.KeyValuePair]
  type Failures = List[zio.aws.ecs.model.Failure]
  type FirelensConfigurationOptionsMap = Map[String, String]
  type GpuIds = List[String]
  type HostEntryList = List[zio.aws.ecs.model.HostEntry]
  type InferenceAcceleratorOverrides =
    List[zio.aws.ecs.model.InferenceAcceleratorOverride]
  type InferenceAccelerators = List[zio.aws.ecs.model.InferenceAccelerator]
  type InstanceHealthCheckResultList =
    List[zio.aws.ecs.model.InstanceHealthCheckResult]
  type LoadBalancers = List[zio.aws.ecs.model.LoadBalancer]
  type LogConfigurationOptionsMap = Map[String, String]
  type ManagedAgentStateChanges =
    List[zio.aws.ecs.model.ManagedAgentStateChange]
  type ManagedAgents = List[zio.aws.ecs.model.ManagedAgent]
  type MountPointList = List[zio.aws.ecs.model.MountPoint]
  type NetworkBindings = List[zio.aws.ecs.model.NetworkBinding]
  type NetworkInterfaces = List[zio.aws.ecs.model.NetworkInterface]
  type PlacementConstraints = List[zio.aws.ecs.model.PlacementConstraint]
  type PlacementStrategies = List[zio.aws.ecs.model.PlacementStrategy]
  type PlatformDevices = List[zio.aws.ecs.model.PlatformDevice]
  type PortMappingList = List[zio.aws.ecs.model.PortMapping]
  type ProxyConfigurationProperties = List[zio.aws.ecs.model.KeyValuePair]
  type RequiresAttributes = List[zio.aws.ecs.model.Attribute]
  type ResourceRequirements = List[zio.aws.ecs.model.ResourceRequirement]
  type Resources = List[zio.aws.ecs.model.Resource]
  type SecretList = List[zio.aws.ecs.model.Secret]
  type ServiceEvents = List[zio.aws.ecs.model.ServiceEvent]
  type ServiceFieldList = List[zio.aws.ecs.model.ServiceField]
  type ServiceRegistries = List[zio.aws.ecs.model.ServiceRegistry]
  type Services = List[zio.aws.ecs.model.Service]
  type Settings = List[zio.aws.ecs.model.Setting]
  type Statistics = List[zio.aws.ecs.model.KeyValuePair]
  type StringList = List[String]
  type StringMap = Map[String, String]
  type SystemControls = List[zio.aws.ecs.model.SystemControl]
  type TagKeys = List[TagKey]
  type Tags = List[zio.aws.ecs.model.Tag]
  type TaskDefinitionFieldList = List[zio.aws.ecs.model.TaskDefinitionField]
  type TaskDefinitionPlacementConstraints =
    List[zio.aws.ecs.model.TaskDefinitionPlacementConstraint]
  type TaskFieldList = List[zio.aws.ecs.model.TaskField]
  type TaskSetFieldList = List[zio.aws.ecs.model.TaskSetField]
  type TaskSets = List[zio.aws.ecs.model.TaskSet]
  type Tasks = List[zio.aws.ecs.model.Task]
  type TmpfsList = List[zio.aws.ecs.model.Tmpfs]
  type UlimitList = List[zio.aws.ecs.model.Ulimit]
  type VolumeFromList = List[zio.aws.ecs.model.VolumeFrom]
  type VolumeList = List[zio.aws.ecs.model.Volume]
}
