package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateServicePrimaryTaskSetRequest(
    cluster: String,
    service: String,
    primaryTaskSet: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest = {
    import UpdateServicePrimaryTaskSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .service(service: java.lang.String)
      .primaryTaskSet(primaryTaskSet: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.UpdateServicePrimaryTaskSetRequest.ReadOnly =
    zio.aws.ecs.model.UpdateServicePrimaryTaskSetRequest.wrap(buildAwsValue())
}
object UpdateServicePrimaryTaskSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateServicePrimaryTaskSetRequest =
      zio.aws.ecs.model
        .UpdateServicePrimaryTaskSetRequest(cluster, service, primaryTaskSet)
    def cluster: String
    def service: String
    def primaryTaskSet: String
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getService: ZIO[Any, Nothing, String] = ZIO.succeed(service)
    def getPrimaryTaskSet: ZIO[Any, Nothing, String] =
      ZIO.succeed(primaryTaskSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest
  ) extends zio.aws.ecs.model.UpdateServicePrimaryTaskSetRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val service: String = impl.service(): String
    override val primaryTaskSet: String = impl.primaryTaskSet(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateServicePrimaryTaskSetRequest
  ): zio.aws.ecs.model.UpdateServicePrimaryTaskSetRequest.ReadOnly =
    new Wrapper(impl)
}
