package zio.aws.ecs
import zio.aws.ecs.model.RegisterContainerInstanceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.ecs.EcsAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ecs.model.{
  DeleteAccountSettingRequest,
  DeregisterContainerInstanceRequest,
  DeregisterTaskDefinitionRequest,
  ListTaskDefinitionFamiliesRequest,
  UpdateClusterRequest,
  DeleteTaskSetRequest,
  SubmitContainerStateChangeRequest,
  DeleteServiceRequest,
  RegisterContainerInstanceRequest,
  DescribeTasksRequest,
  PutAccountSettingRequest,
  DescribeContainerInstancesRequest,
  PutAccountSettingDefaultRequest,
  UpdateTaskSetRequest,
  CreateTaskSetRequest,
  UpdateContainerAgentRequest,
  StartTaskRequest,
  ListTagsForResourceRequest,
  SubmitAttachmentStateChangesRequest,
  ExecuteCommandRequest,
  CreateClusterRequest,
  DescribeTaskSetsRequest,
  RegisterTaskDefinitionRequest,
  UpdateContainerInstancesStateRequest,
  DescribeServicesRequest,
  CreateServiceRequest,
  DeleteAttributesRequest,
  DeleteClusterRequest,
  DescribeTaskDefinitionRequest,
  DeleteCapacityProviderRequest,
  ListTasksRequest,
  ListTaskDefinitionsRequest,
  StopTaskRequest,
  UntagResourceRequest,
  CreateCapacityProviderRequest,
  UpdateClusterSettingsRequest,
  DescribeCapacityProvidersRequest,
  SubmitTaskStateChangeRequest,
  ListContainerInstancesRequest,
  RunTaskRequest,
  ListServicesRequest,
  PutAttributesRequest,
  DiscoverPollEndpointRequest,
  ListAttributesRequest,
  PutClusterCapacityProvidersRequest,
  UpdateServiceRequest,
  ListClustersRequest,
  DescribeClustersRequest,
  UpdateServicePrimaryTaskSetRequest,
  TagResourceRequest,
  ListAccountSettingsRequest,
  UpdateCapacityProviderRequest
}
import zio.stream.ZStream
object EcsMock extends Mock[Ecs] {
  object RegisterTaskDefinition
      extends Effect[
        RegisterTaskDefinitionRequest,
        AwsError,
        zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly
      ]
  object SubmitContainerStateChange
      extends Effect[
        SubmitContainerStateChangeRequest,
        AwsError,
        zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly
      ]
  object SubmitAttachmentStateChanges
      extends Effect[
        SubmitAttachmentStateChangesRequest,
        AwsError,
        zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly
      ]
  object DescribeTaskDefinition
      extends Effect[
        DescribeTaskDefinitionRequest,
        AwsError,
        zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly
      ]
  object DescribeClusters
      extends Effect[
        DescribeClustersRequest,
        AwsError,
        zio.aws.ecs.model.DescribeClustersResponse.ReadOnly
      ]
  object PutAccountSettingDefault
      extends Effect[
        PutAccountSettingDefaultRequest,
        AwsError,
        zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly
      ]
  object PutAttributes
      extends Effect[
        PutAttributesRequest,
        AwsError,
        zio.aws.ecs.model.PutAttributesResponse.ReadOnly
      ]
  object ListTaskDefinitionFamilies
      extends Stream[ListTaskDefinitionFamiliesRequest, AwsError, String]
  object ListTaskDefinitionFamiliesPaginated
      extends Effect[
        ListTaskDefinitionFamiliesRequest,
        AwsError,
        zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly
      ]
  object CreateService
      extends Effect[
        CreateServiceRequest,
        AwsError,
        zio.aws.ecs.model.CreateServiceResponse.ReadOnly
      ]
  object CreateTaskSet
      extends Effect[
        CreateTaskSetRequest,
        AwsError,
        zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly
      ]
  object StartTask
      extends Effect[
        StartTaskRequest,
        AwsError,
        zio.aws.ecs.model.StartTaskResponse.ReadOnly
      ]
  object DeleteTaskSet
      extends Effect[
        DeleteTaskSetRequest,
        AwsError,
        zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly
      ]
  object DeregisterContainerInstance
      extends Effect[
        DeregisterContainerInstanceRequest,
        AwsError,
        zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly
      ]
  object DiscoverPollEndpoint
      extends Effect[
        DiscoverPollEndpointRequest,
        AwsError,
        zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly
      ]
  object RegisterContainerInstance
      extends Effect[RegisterContainerInstanceRequest, AwsError, ReadOnly]
  object DescribeContainerInstances
      extends Effect[
        DescribeContainerInstancesRequest,
        AwsError,
        zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly
      ]
  object DeleteAttributes
      extends Effect[
        DeleteAttributesRequest,
        AwsError,
        zio.aws.ecs.model.DeleteAttributesResponse.ReadOnly
      ]
  object DeleteService
      extends Effect[
        DeleteServiceRequest,
        AwsError,
        zio.aws.ecs.model.DeleteServiceResponse.ReadOnly
      ]
  object PutClusterCapacityProviders
      extends Effect[
        PutClusterCapacityProvidersRequest,
        AwsError,
        zio.aws.ecs.model.PutClusterCapacityProvidersResponse.ReadOnly
      ]
  object ListServices extends Stream[ListServicesRequest, AwsError, String]
  object ListServicesPaginated
      extends Effect[
        ListServicesRequest,
        AwsError,
        zio.aws.ecs.model.ListServicesResponse.ReadOnly
      ]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.ecs.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.ecs.model.DeleteClusterResponse.ReadOnly
      ]
  object DescribeTaskSets
      extends Effect[
        DescribeTaskSetsRequest,
        AwsError,
        zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly
      ]
  object UpdateCluster
      extends Effect[
        UpdateClusterRequest,
        AwsError,
        zio.aws.ecs.model.UpdateClusterResponse.ReadOnly
      ]
  object ExecuteCommand
      extends Effect[
        ExecuteCommandRequest,
        AwsError,
        zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly
      ]
  object RunTask
      extends Effect[
        RunTaskRequest,
        AwsError,
        zio.aws.ecs.model.RunTaskResponse.ReadOnly
      ]
  object ListContainerInstances
      extends Stream[ListContainerInstancesRequest, AwsError, String]
  object ListContainerInstancesPaginated
      extends Effect[
        ListContainerInstancesRequest,
        AwsError,
        zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ecs.model.UntagResourceResponse.ReadOnly
      ]
  object SubmitTaskStateChange
      extends Effect[
        SubmitTaskStateChangeRequest,
        AwsError,
        zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly
      ]
  object UpdateServicePrimaryTaskSet
      extends Effect[
        UpdateServicePrimaryTaskSetRequest,
        AwsError,
        zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly
      ]
  object DescribeTasks
      extends Effect[
        DescribeTasksRequest,
        AwsError,
        zio.aws.ecs.model.DescribeTasksResponse.ReadOnly
      ]
  object DescribeCapacityProviders
      extends Effect[
        DescribeCapacityProvidersRequest,
        AwsError,
        zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly
      ]
  object ListTaskDefinitions
      extends Stream[ListTaskDefinitionsRequest, AwsError, String]
  object ListTaskDefinitionsPaginated
      extends Effect[
        ListTaskDefinitionsRequest,
        AwsError,
        zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly
      ]
  object DeleteCapacityProvider
      extends Effect[
        DeleteCapacityProviderRequest,
        AwsError,
        zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly
      ]
  object DeregisterTaskDefinition
      extends Effect[
        DeregisterTaskDefinitionRequest,
        AwsError,
        zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly
      ]
  object UpdateClusterSettings
      extends Effect[
        UpdateClusterSettingsRequest,
        AwsError,
        zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ecs.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateContainerInstancesState
      extends Effect[
        UpdateContainerInstancesStateRequest,
        AwsError,
        zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly
      ]
  object ListClusters extends Stream[ListClustersRequest, AwsError, String]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.ecs.model.ListClustersResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ecs.model.TagResourceResponse.ReadOnly
      ]
  object UpdateTaskSet
      extends Effect[
        UpdateTaskSetRequest,
        AwsError,
        zio.aws.ecs.model.UpdateTaskSetResponse.ReadOnly
      ]
  object ListAccountSettings
      extends Stream[
        ListAccountSettingsRequest,
        AwsError,
        zio.aws.ecs.model.Setting.ReadOnly
      ]
  object ListAccountSettingsPaginated
      extends Effect[
        ListAccountSettingsRequest,
        AwsError,
        zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly
      ]
  object ListTasks extends Stream[ListTasksRequest, AwsError, String]
  object ListTasksPaginated
      extends Effect[
        ListTasksRequest,
        AwsError,
        zio.aws.ecs.model.ListTasksResponse.ReadOnly
      ]
  object DeleteAccountSetting
      extends Effect[
        DeleteAccountSettingRequest,
        AwsError,
        zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly
      ]
  object UpdateContainerAgent
      extends Effect[
        UpdateContainerAgentRequest,
        AwsError,
        zio.aws.ecs.model.UpdateContainerAgentResponse.ReadOnly
      ]
  object UpdateService
      extends Effect[
        UpdateServiceRequest,
        AwsError,
        zio.aws.ecs.model.UpdateServiceResponse.ReadOnly
      ]
  object StopTask
      extends Effect[
        StopTaskRequest,
        AwsError,
        zio.aws.ecs.model.StopTaskResponse.ReadOnly
      ]
  object UpdateCapacityProvider
      extends Effect[
        UpdateCapacityProviderRequest,
        AwsError,
        zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly
      ]
  object PutAccountSetting
      extends Effect[
        PutAccountSettingRequest,
        AwsError,
        zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly
      ]
  object CreateCapacityProvider
      extends Effect[
        CreateCapacityProviderRequest,
        AwsError,
        zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly
      ]
  object ListAttributes
      extends Stream[
        ListAttributesRequest,
        AwsError,
        zio.aws.ecs.model.Attribute.ReadOnly
      ]
  object ListAttributesPaginated
      extends Effect[
        ListAttributesRequest,
        AwsError,
        zio.aws.ecs.model.ListAttributesResponse.ReadOnly
      ]
  object DescribeServices
      extends Effect[
        DescribeServicesRequest,
        AwsError,
        zio.aws.ecs.model.DescribeServicesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ecs] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Ecs {
          val api: EcsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Ecs = this
          def registerTaskDefinition(
              request: RegisterTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.RegisterTaskDefinitionResponse.ReadOnly
          ] = proxy(RegisterTaskDefinition, request)
          def submitContainerStateChange(
              request: SubmitContainerStateChangeRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.SubmitContainerStateChangeResponse.ReadOnly
          ] = proxy(SubmitContainerStateChange, request)
          def submitAttachmentStateChanges(
              request: SubmitAttachmentStateChangesRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.SubmitAttachmentStateChangesResponse.ReadOnly
          ] = proxy(SubmitAttachmentStateChanges, request)
          def describeTaskDefinition(
              request: DescribeTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DescribeTaskDefinitionResponse.ReadOnly
          ] = proxy(DescribeTaskDefinition, request)
          def describeClusters(
              request: DescribeClustersRequest
          ): IO[AwsError, zio.aws.ecs.model.DescribeClustersResponse.ReadOnly] =
            proxy(DescribeClusters, request)
          def putAccountSettingDefault(
              request: PutAccountSettingDefaultRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.PutAccountSettingDefaultResponse.ReadOnly
          ] = proxy(PutAccountSettingDefault, request)
          def putAttributes(
              request: PutAttributesRequest
          ): IO[AwsError, zio.aws.ecs.model.PutAttributesResponse.ReadOnly] =
            proxy(PutAttributes, request)
          def listTaskDefinitionFamilies(
              request: ListTaskDefinitionFamiliesRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListTaskDefinitionFamilies, request))
          def listTaskDefinitionFamiliesPaginated(
              request: ListTaskDefinitionFamiliesRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly
          ] = proxy(ListTaskDefinitionFamiliesPaginated, request)
          def createService(
              request: CreateServiceRequest
          ): IO[AwsError, zio.aws.ecs.model.CreateServiceResponse.ReadOnly] =
            proxy(CreateService, request)
          def createTaskSet(
              request: CreateTaskSetRequest
          ): IO[AwsError, zio.aws.ecs.model.CreateTaskSetResponse.ReadOnly] =
            proxy(CreateTaskSet, request)
          def startTask(
              request: StartTaskRequest
          ): IO[AwsError, zio.aws.ecs.model.StartTaskResponse.ReadOnly] =
            proxy(StartTask, request)
          def deleteTaskSet(
              request: DeleteTaskSetRequest
          ): IO[AwsError, zio.aws.ecs.model.DeleteTaskSetResponse.ReadOnly] =
            proxy(DeleteTaskSet, request)
          def deregisterContainerInstance(
              request: DeregisterContainerInstanceRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DeregisterContainerInstanceResponse.ReadOnly
          ] = proxy(DeregisterContainerInstance, request)
          def discoverPollEndpoint(request: DiscoverPollEndpointRequest): IO[
            AwsError,
            zio.aws.ecs.model.DiscoverPollEndpointResponse.ReadOnly
          ] = proxy(DiscoverPollEndpoint, request)
          def registerContainerInstance(
              request: RegisterContainerInstanceRequest
          ): IO[AwsError, ReadOnly] = proxy(RegisterContainerInstance, request)
          def describeContainerInstances(
              request: DescribeContainerInstancesRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DescribeContainerInstancesResponse.ReadOnly
          ] = proxy(DescribeContainerInstances, request)
          def deleteAttributes(
              request: DeleteAttributesRequest
          ): IO[AwsError, zio.aws.ecs.model.DeleteAttributesResponse.ReadOnly] =
            proxy(DeleteAttributes, request)
          def deleteService(
              request: DeleteServiceRequest
          ): IO[AwsError, zio.aws.ecs.model.DeleteServiceResponse.ReadOnly] =
            proxy(DeleteService, request)
          def putClusterCapacityProviders(
              request: PutClusterCapacityProvidersRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.PutClusterCapacityProvidersResponse.ReadOnly
          ] = proxy(PutClusterCapacityProviders, request)
          def listServices(
              request: ListServicesRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListServices, request))
          def listServicesPaginated(
              request: ListServicesRequest
          ): IO[AwsError, zio.aws.ecs.model.ListServicesResponse.ReadOnly] =
            proxy(ListServicesPaginated, request)
          def createCluster(
              request: CreateClusterRequest
          ): IO[AwsError, zio.aws.ecs.model.CreateClusterResponse.ReadOnly] =
            proxy(CreateCluster, request)
          def deleteCluster(
              request: DeleteClusterRequest
          ): IO[AwsError, zio.aws.ecs.model.DeleteClusterResponse.ReadOnly] =
            proxy(DeleteCluster, request)
          def describeTaskSets(
              request: DescribeTaskSetsRequest
          ): IO[AwsError, zio.aws.ecs.model.DescribeTaskSetsResponse.ReadOnly] =
            proxy(DescribeTaskSets, request)
          def updateCluster(
              request: UpdateClusterRequest
          ): IO[AwsError, zio.aws.ecs.model.UpdateClusterResponse.ReadOnly] =
            proxy(UpdateCluster, request)
          def executeCommand(
              request: ExecuteCommandRequest
          ): IO[AwsError, zio.aws.ecs.model.ExecuteCommandResponse.ReadOnly] =
            proxy(ExecuteCommand, request)
          def runTask(
              request: RunTaskRequest
          ): IO[AwsError, zio.aws.ecs.model.RunTaskResponse.ReadOnly] =
            proxy(RunTask, request)
          def listContainerInstances(
              request: ListContainerInstancesRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListContainerInstances, request))
          def listContainerInstancesPaginated(
              request: ListContainerInstancesRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.ListContainerInstancesResponse.ReadOnly
          ] = proxy(ListContainerInstancesPaginated, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.ecs.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def submitTaskStateChange(request: SubmitTaskStateChangeRequest): IO[
            AwsError,
            zio.aws.ecs.model.SubmitTaskStateChangeResponse.ReadOnly
          ] = proxy(SubmitTaskStateChange, request)
          def updateServicePrimaryTaskSet(
              request: UpdateServicePrimaryTaskSetRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.UpdateServicePrimaryTaskSetResponse.ReadOnly
          ] = proxy(UpdateServicePrimaryTaskSet, request)
          def describeTasks(
              request: DescribeTasksRequest
          ): IO[AwsError, zio.aws.ecs.model.DescribeTasksResponse.ReadOnly] =
            proxy(DescribeTasks, request)
          def describeCapacityProviders(
              request: DescribeCapacityProvidersRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DescribeCapacityProvidersResponse.ReadOnly
          ] = proxy(DescribeCapacityProviders, request)
          def listTaskDefinitions(
              request: ListTaskDefinitionsRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListTaskDefinitions, request))
          def listTaskDefinitionsPaginated(
              request: ListTaskDefinitionsRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.ListTaskDefinitionsResponse.ReadOnly
          ] = proxy(ListTaskDefinitionsPaginated, request)
          def deleteCapacityProvider(
              request: DeleteCapacityProviderRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DeleteCapacityProviderResponse.ReadOnly
          ] = proxy(DeleteCapacityProvider, request)
          def deregisterTaskDefinition(
              request: DeregisterTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.DeregisterTaskDefinitionResponse.ReadOnly
          ] = proxy(DeregisterTaskDefinition, request)
          def updateClusterSettings(request: UpdateClusterSettingsRequest): IO[
            AwsError,
            zio.aws.ecs.model.UpdateClusterSettingsResponse.ReadOnly
          ] = proxy(UpdateClusterSettings, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.ecs.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def updateContainerInstancesState(
              request: UpdateContainerInstancesStateRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.UpdateContainerInstancesStateResponse.ReadOnly
          ] = proxy(UpdateContainerInstancesState, request)
          def listClusters(
              request: ListClustersRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListClusters, request))
          def listClustersPaginated(
              request: ListClustersRequest
          ): IO[AwsError, zio.aws.ecs.model.ListClustersResponse.ReadOnly] =
            proxy(ListClustersPaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.ecs.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateTaskSet(
              request: UpdateTaskSetRequest
          ): IO[AwsError, zio.aws.ecs.model.UpdateTaskSetResponse.ReadOnly] =
            proxy(UpdateTaskSet, request)
          def listAccountSettings(
              request: ListAccountSettingsRequest
          ): ZStream[Any, AwsError, zio.aws.ecs.model.Setting.ReadOnly] =
            rts.unsafeRun(proxy(ListAccountSettings, request))
          def listAccountSettingsPaginated(
              request: ListAccountSettingsRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.ListAccountSettingsResponse.ReadOnly
          ] = proxy(ListAccountSettingsPaginated, request)
          def listTasks(
              request: ListTasksRequest
          ): ZStream[Any, AwsError, String] =
            rts.unsafeRun(proxy(ListTasks, request))
          def listTasksPaginated(
              request: ListTasksRequest
          ): IO[AwsError, zio.aws.ecs.model.ListTasksResponse.ReadOnly] =
            proxy(ListTasksPaginated, request)
          def deleteAccountSetting(request: DeleteAccountSettingRequest): IO[
            AwsError,
            zio.aws.ecs.model.DeleteAccountSettingResponse.ReadOnly
          ] = proxy(DeleteAccountSetting, request)
          def updateContainerAgent(request: UpdateContainerAgentRequest): IO[
            AwsError,
            zio.aws.ecs.model.UpdateContainerAgentResponse.ReadOnly
          ] = proxy(UpdateContainerAgent, request)
          def updateService(
              request: UpdateServiceRequest
          ): IO[AwsError, zio.aws.ecs.model.UpdateServiceResponse.ReadOnly] =
            proxy(UpdateService, request)
          def stopTask(
              request: StopTaskRequest
          ): IO[AwsError, zio.aws.ecs.model.StopTaskResponse.ReadOnly] =
            proxy(StopTask, request)
          def updateCapacityProvider(
              request: UpdateCapacityProviderRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.UpdateCapacityProviderResponse.ReadOnly
          ] = proxy(UpdateCapacityProvider, request)
          def putAccountSetting(request: PutAccountSettingRequest): IO[
            AwsError,
            zio.aws.ecs.model.PutAccountSettingResponse.ReadOnly
          ] = proxy(PutAccountSetting, request)
          def createCapacityProvider(
              request: CreateCapacityProviderRequest
          ): IO[
            AwsError,
            zio.aws.ecs.model.CreateCapacityProviderResponse.ReadOnly
          ] = proxy(CreateCapacityProvider, request)
          def listAttributes(
              request: ListAttributesRequest
          ): ZStream[Any, AwsError, zio.aws.ecs.model.Attribute.ReadOnly] =
            rts.unsafeRun(proxy(ListAttributes, request))
          def listAttributesPaginated(
              request: ListAttributesRequest
          ): IO[AwsError, zio.aws.ecs.model.ListAttributesResponse.ReadOnly] =
            proxy(ListAttributesPaginated, request)
          def describeServices(
              request: DescribeServicesRequest
          ): IO[AwsError, zio.aws.ecs.model.DescribeServicesResponse.ReadOnly] =
            proxy(DescribeServices, request)
        }
      }
    }
    .toLayer
}
