package zio.aws.ecs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ecs.model.primitives.BoxedInteger
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SubmitContainerStateChangeRequest(
    cluster: Optional[String] = Optional.Absent,
    task: Optional[String] = Optional.Absent,
    containerName: Optional[String] = Optional.Absent,
    runtimeId: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    exitCode: Optional[BoxedInteger] = Optional.Absent,
    reason: Optional[String] = Optional.Absent,
    networkBindings: Optional[Iterable[zio.aws.ecs.model.NetworkBinding]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest = {
    import SubmitContainerStateChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(containerName.map(value => value: java.lang.String))(
        _.containerName
      )
      .optionallyWith(runtimeId.map(value => value: java.lang.String))(
        _.runtimeId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(exitCode.map(value => value: Integer))(_.exitCode)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        networkBindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkBindings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly =
    zio.aws.ecs.model.SubmitContainerStateChangeRequest.wrap(buildAwsValue())
}
object SubmitContainerStateChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitContainerStateChangeRequest =
      zio.aws.ecs.model.SubmitContainerStateChangeRequest(
        cluster.map(value => value),
        task.map(value => value),
        containerName.map(value => value),
        runtimeId.map(value => value),
        status.map(value => value),
        exitCode.map(value => value),
        reason.map(value => value),
        networkBindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cluster: Optional[String]
    def task: Optional[String]
    def containerName: Optional[String]
    def runtimeId: Optional[String]
    def status: Optional[String]
    def exitCode: Optional[BoxedInteger]
    def reason: Optional[String]
    def networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getContainerName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerName", containerName)
    def getRuntimeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("runtimeId", runtimeId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getExitCode: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("exitCode", exitCode)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getNetworkBindings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      AwsError.unwrapOptionField("networkBindings", networkBindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ) extends zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly {
    override val cluster: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cluster())
      .map(value => value: String)
    override val task: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.task())
      .map(value => value: String)
    override val containerName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => value: String)
    override val runtimeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeId())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val exitCode: Optional[BoxedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.exitCode())
      .map(value => value: BoxedInteger)
    override val reason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => value: String)
    override val networkBindings
        : Optional[List[zio.aws.ecs.model.NetworkBinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkBindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.NetworkBinding.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitContainerStateChangeRequest
  ): zio.aws.ecs.model.SubmitContainerStateChangeRequest.ReadOnly = new Wrapper(
    impl
  )
}
