package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SubmitTaskStateChangeRequest(
    cluster: Option[String] = None,
    task: Option[String] = None,
    status: Option[String] = None,
    reason: Option[String] = None,
    containers: Option[Iterable[zio.aws.ecs.model.ContainerStateChange]] = None,
    attachments: Option[Iterable[zio.aws.ecs.model.AttachmentStateChange]] =
      None,
    managedAgents: Option[Iterable[zio.aws.ecs.model.ManagedAgentStateChange]] =
      None,
    pullStartedAt: Option[Timestamp] = None,
    pullStoppedAt: Option[Timestamp] = None,
    executionStoppedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest = {
    import SubmitTaskStateChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(task.map(value => value: java.lang.String))(_.task)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(reason.map(value => value: java.lang.String))(_.reason)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .optionallyWith(
        attachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachments)
      .optionallyWith(
        managedAgents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedAgents)
      .optionallyWith(
        pullStartedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStartedAt)
      .optionallyWith(
        pullStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.pullStoppedAt)
      .optionallyWith(
        executionStoppedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.executionStoppedAt)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly =
    zio.aws.ecs.model.SubmitTaskStateChangeRequest.wrap(buildAwsValue())
}
object SubmitTaskStateChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.SubmitTaskStateChangeRequest =
      zio.aws.ecs.model.SubmitTaskStateChangeRequest(
        cluster.map(value => value),
        task.map(value => value),
        status.map(value => value),
        reason.map(value => value),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        managedAgents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        pullStartedAt.map(value => value),
        pullStoppedAt.map(value => value),
        executionStoppedAt.map(value => value)
      )
    def cluster: Option[String]
    def task: Option[String]
    def status: Option[String]
    def reason: Option[String]
    def containers
        : Option[List[zio.aws.ecs.model.ContainerStateChange.ReadOnly]]
    def attachments
        : Option[List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly]]
    def managedAgents
        : Option[List[zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly]]
    def pullStartedAt: Option[Timestamp]
    def pullStoppedAt: Option[Timestamp]
    def executionStoppedAt: Option[Timestamp]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getTask: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("task", task)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("reason", reason)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ContainerStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
    def getAttachments: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.AttachmentStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("attachments", attachments)
    def getManagedAgents: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly
    ]] = AwsError.unwrapOptionField("managedAgents", managedAgents)
    def getPullStartedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStartedAt", pullStartedAt)
    def getPullStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("pullStoppedAt", pullStoppedAt)
    def getExecutionStoppedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executionStoppedAt", executionStoppedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ) extends zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val task: Option[String] =
      scala.Option(impl.task()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val reason: Option[String] =
      scala.Option(impl.reason()).map(value => value: String)
    override val containers
        : Option[List[zio.aws.ecs.model.ContainerStateChange.ReadOnly]] = scala
      .Option(impl.containers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerStateChange.wrap(item)
        }.toList
      )
    override val attachments
        : Option[List[zio.aws.ecs.model.AttachmentStateChange.ReadOnly]] = scala
      .Option(impl.attachments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.AttachmentStateChange.wrap(item)
        }.toList
      )
    override val managedAgents
        : Option[List[zio.aws.ecs.model.ManagedAgentStateChange.ReadOnly]] =
      scala
        .Option(impl.managedAgents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ManagedAgentStateChange.wrap(item)
          }.toList
        )
    override val pullStartedAt: Option[Timestamp] = scala
      .Option(impl.pullStartedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val pullStoppedAt: Option[Timestamp] = scala
      .Option(impl.pullStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val executionStoppedAt: Option[Timestamp] = scala
      .Option(impl.executionStoppedAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.SubmitTaskStateChangeRequest
  ): zio.aws.ecs.model.SubmitTaskStateChangeRequest.ReadOnly = new Wrapper(impl)
}
