package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RunTaskResponse(
    tasks: Option[Iterable[zio.aws.ecs.model.Task]] = None,
    failures: Option[Iterable[zio.aws.ecs.model.Failure]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.RunTaskResponse = {
    import RunTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.RunTaskResponse
      .builder()
      .optionallyWith(
        tasks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tasks)
      .optionallyWith(
        failures.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failures)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.RunTaskResponse.ReadOnly =
    zio.aws.ecs.model.RunTaskResponse.wrap(buildAwsValue())
}
object RunTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.RunTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.RunTaskResponse =
      zio.aws.ecs.model.RunTaskResponse(
        tasks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failures.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def tasks: Option[List[zio.aws.ecs.model.Task.ReadOnly]]
    def failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]]
    def getTasks: ZIO[Any, AwsError, List[zio.aws.ecs.model.Task.ReadOnly]] =
      AwsError.unwrapOptionField("tasks", tasks)
    def getFailures
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Failure.ReadOnly]] =
      AwsError.unwrapOptionField("failures", failures)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskResponse
  ) extends zio.aws.ecs.model.RunTaskResponse.ReadOnly {
    override val tasks: Option[List[zio.aws.ecs.model.Task.ReadOnly]] = scala
      .Option(impl.tasks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Task.wrap(item)
        }.toList
      )
    override val failures: Option[List[zio.aws.ecs.model.Failure.ReadOnly]] =
      scala
        .Option(impl.failures())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.Failure.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.RunTaskResponse
  ): zio.aws.ecs.model.RunTaskResponse.ReadOnly = new Wrapper(impl)
}
