package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeContainerInstancesRequest(
    cluster: Option[String] = None,
    containerInstances: Iterable[String],
    include: Option[Iterable[zio.aws.ecs.model.ContainerInstanceField]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest = {
    import DescribeContainerInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .containerInstances(containerInstances.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        include.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.includeWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.DescribeContainerInstancesRequest.ReadOnly =
    zio.aws.ecs.model.DescribeContainerInstancesRequest.wrap(buildAwsValue())
}
object DescribeContainerInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.DescribeContainerInstancesRequest =
      zio.aws.ecs.model.DescribeContainerInstancesRequest(
        cluster.map(value => value),
        containerInstances,
        include.map(value => value)
      )
    def cluster: Option[String]
    def containerInstances: List[String]
    def include: Option[List[zio.aws.ecs.model.ContainerInstanceField]]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstances: ZIO[Any, Nothing, List[String]] =
      ZIO.succeed(containerInstances)
    def getInclude
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ContainerInstanceField]] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest
  ) extends zio.aws.ecs.model.DescribeContainerInstancesRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val containerInstances: List[String] = impl
      .containerInstances()
      .asScala
      .map { item =>
        item: String
      }
      .toList
    override val include
        : Option[List[zio.aws.ecs.model.ContainerInstanceField]] = scala
      .Option(impl.include())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ContainerInstanceField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.DescribeContainerInstancesRequest
  ): zio.aws.ecs.model.DescribeContainerInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
