package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterRequest(
    cluster: String,
    settings: Option[Iterable[zio.aws.ecs.model.ClusterSetting]] = None,
    configuration: Option[zio.aws.ecs.model.ClusterConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.UpdateClusterRequest = {
    import UpdateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
      .builder()
      .cluster(cluster: java.lang.String)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.UpdateClusterRequest.ReadOnly =
    zio.aws.ecs.model.UpdateClusterRequest.wrap(buildAwsValue())
}
object UpdateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.UpdateClusterRequest =
      zio.aws.ecs.model.UpdateClusterRequest(
        cluster,
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable)
      )
    def cluster: String
    def settings: Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def configuration: Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def getCluster: ZIO[Any, Nothing, String] = ZIO.succeed(cluster)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ) extends zio.aws.ecs.model.UpdateClusterRequest.ReadOnly {
    override val cluster: String = impl.cluster(): String
    override val settings
        : Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] = scala
      .Option(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ClusterSetting.wrap(item)
        }.toList
      )
    override val configuration
        : Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.UpdateClusterRequest
  ): zio.aws.ecs.model.UpdateClusterRequest.ReadOnly = new Wrapper(impl)
}
