package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait ProxyConfigurationType {
  def unwrap: software.amazon.awssdk.services.ecs.model.ProxyConfigurationType
}
object ProxyConfigurationType {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.ProxyConfigurationType
  ): zio.aws.ecs.model.ProxyConfigurationType = value match {
    case software.amazon.awssdk.services.ecs.model.ProxyConfigurationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.ProxyConfigurationType.APPMESH =>
      val r = APPMESH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.ProxyConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ProxyConfigurationType =
      software.amazon.awssdk.services.ecs.model.ProxyConfigurationType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPMESH extends zio.aws.ecs.model.ProxyConfigurationType {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.ProxyConfigurationType =
      software.amazon.awssdk.services.ecs.model.ProxyConfigurationType.APPMESH
  }
}
