package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTasksRequest(
    cluster: Option[String] = None,
    containerInstance: Option[String] = None,
    family: Option[String] = None,
    nextToken: Option[String] = None,
    maxResults: Option[BoxedInteger] = None,
    startedBy: Option[String] = None,
    serviceName: Option[String] = None,
    desiredStatus: Option[zio.aws.ecs.model.DesiredStatus] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTasksRequest = {
    import ListTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTasksRequest
      .builder()
      .optionallyWith(cluster.map(value => value: java.lang.String))(_.cluster)
      .optionallyWith(containerInstance.map(value => value: java.lang.String))(
        _.containerInstance
      )
      .optionallyWith(family.map(value => value: java.lang.String))(_.family)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .optionallyWith(startedBy.map(value => value: java.lang.String))(
        _.startedBy
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(desiredStatus.map(value => value.unwrap))(_.desiredStatus)
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTasksRequest.ReadOnly =
    zio.aws.ecs.model.ListTasksRequest.wrap(buildAwsValue())
}
object ListTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTasksRequest =
      zio.aws.ecs.model.ListTasksRequest(
        cluster.map(value => value),
        containerInstance.map(value => value),
        family.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        startedBy.map(value => value),
        serviceName.map(value => value),
        desiredStatus.map(value => value),
        launchType.map(value => value)
      )
    def cluster: Option[String]
    def containerInstance: Option[String]
    def family: Option[String]
    def nextToken: Option[String]
    def maxResults: Option[BoxedInteger]
    def startedBy: Option[String]
    def serviceName: Option[String]
    def desiredStatus: Option[zio.aws.ecs.model.DesiredStatus]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def getCluster: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cluster", cluster)
    def getContainerInstance: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("containerInstance", containerInstance)
    def getFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("family", family)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getDesiredStatus: ZIO[Any, AwsError, zio.aws.ecs.model.DesiredStatus] =
      AwsError.unwrapOptionField("desiredStatus", desiredStatus)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ) extends zio.aws.ecs.model.ListTasksRequest.ReadOnly {
    override val cluster: Option[String] =
      scala.Option(impl.cluster()).map(value => value: String)
    override val containerInstance: Option[String] =
      scala.Option(impl.containerInstance()).map(value => value: String)
    override val family: Option[String] =
      scala.Option(impl.family()).map(value => value: String)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val maxResults: Option[BoxedInteger] =
      scala.Option(impl.maxResults()).map(value => value: BoxedInteger)
    override val startedBy: Option[String] =
      scala.Option(impl.startedBy()).map(value => value: String)
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
    override val desiredStatus: Option[zio.aws.ecs.model.DesiredStatus] = scala
      .Option(impl.desiredStatus())
      .map(value => zio.aws.ecs.model.DesiredStatus.wrap(value))
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksRequest
  ): zio.aws.ecs.model.ListTasksRequest.ReadOnly = new Wrapper(impl)
}
