package zio.aws.ecs.model
import zio.aws.ecs.model.primitives.{BoxedInteger, Timestamp, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Service(
    serviceArn: Option[String] = None,
    serviceName: Option[String] = None,
    clusterArn: Option[String] = None,
    loadBalancers: Option[Iterable[zio.aws.ecs.model.LoadBalancer]] = None,
    serviceRegistries: Option[Iterable[zio.aws.ecs.model.ServiceRegistry]] =
      None,
    status: Option[String] = None,
    desiredCount: Option[Integer] = None,
    runningCount: Option[Integer] = None,
    pendingCount: Option[Integer] = None,
    launchType: Option[zio.aws.ecs.model.LaunchType] = None,
    capacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None,
    platformVersion: Option[String] = None,
    platformFamily: Option[String] = None,
    taskDefinition: Option[String] = None,
    deploymentConfiguration: Option[zio.aws.ecs.model.DeploymentConfiguration] =
      None,
    taskSets: Option[Iterable[zio.aws.ecs.model.TaskSet]] = None,
    deployments: Option[Iterable[zio.aws.ecs.model.Deployment]] = None,
    roleArn: Option[String] = None,
    events: Option[Iterable[zio.aws.ecs.model.ServiceEvent]] = None,
    createdAt: Option[Timestamp] = None,
    placementConstraints: Option[
      Iterable[zio.aws.ecs.model.PlacementConstraint]
    ] = None,
    placementStrategy: Option[Iterable[zio.aws.ecs.model.PlacementStrategy]] =
      None,
    networkConfiguration: Option[zio.aws.ecs.model.NetworkConfiguration] = None,
    healthCheckGracePeriodSeconds: Option[BoxedInteger] = None,
    schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy] = None,
    deploymentController: Option[zio.aws.ecs.model.DeploymentController] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    createdBy: Option[String] = None,
    enableECSManagedTags: Option[Boolean] = None,
    propagateTags: Option[zio.aws.ecs.model.PropagateTags] = None,
    enableExecuteCommand: Option[Boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ecs.model.Service = {
    import Service.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.Service
      .builder()
      .optionallyWith(serviceArn.map(value => value: java.lang.String))(
        _.serviceArn
      )
      .optionallyWith(serviceName.map(value => value: java.lang.String))(
        _.serviceName
      )
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        loadBalancers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loadBalancers)
      .optionallyWith(
        serviceRegistries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceRegistries)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(desiredCount.map(value => value: java.lang.Integer))(
        _.desiredCount
      )
      .optionallyWith(runningCount.map(value => value: java.lang.Integer))(
        _.runningCount
      )
      .optionallyWith(pendingCount.map(value => value: java.lang.Integer))(
        _.pendingCount
      )
      .optionallyWith(launchType.map(value => value.unwrap))(_.launchType)
      .optionallyWith(
        capacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityProviderStrategy)
      .optionallyWith(platformVersion.map(value => value: java.lang.String))(
        _.platformVersion
      )
      .optionallyWith(platformFamily.map(value => value: java.lang.String))(
        _.platformFamily
      )
      .optionallyWith(taskDefinition.map(value => value: java.lang.String))(
        _.taskDefinition
      )
      .optionallyWith(
        deploymentConfiguration.map(value => value.buildAwsValue())
      )(_.deploymentConfiguration)
      .optionallyWith(
        taskSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskSets)
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployments)
      .optionallyWith(roleArn.map(value => value: java.lang.String))(_.roleArn)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        placementConstraints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementConstraints)
      .optionallyWith(
        placementStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.placementStrategy)
      .optionallyWith(networkConfiguration.map(value => value.buildAwsValue()))(
        _.networkConfiguration
      )
      .optionallyWith(
        healthCheckGracePeriodSeconds.map(value => value: java.lang.Integer)
      )(_.healthCheckGracePeriodSeconds)
      .optionallyWith(schedulingStrategy.map(value => value.unwrap))(
        _.schedulingStrategy
      )
      .optionallyWith(deploymentController.map(value => value.buildAwsValue()))(
        _.deploymentController
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(createdBy.map(value => value: java.lang.String))(
        _.createdBy
      )
      .optionallyWith(
        enableECSManagedTags.map(value => value: java.lang.Boolean)
      )(_.enableECSManagedTags)
      .optionallyWith(propagateTags.map(value => value.unwrap))(_.propagateTags)
      .optionallyWith(
        enableExecuteCommand.map(value => value: java.lang.Boolean)
      )(_.enableExecuteCommand)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.Service.ReadOnly =
    zio.aws.ecs.model.Service.wrap(buildAwsValue())
}
object Service {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ecs.model.Service] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.Service = zio.aws.ecs.model.Service(
      serviceArn.map(value => value),
      serviceName.map(value => value),
      clusterArn.map(value => value),
      loadBalancers.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      serviceRegistries.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      status.map(value => value),
      desiredCount.map(value => value),
      runningCount.map(value => value),
      pendingCount.map(value => value),
      launchType.map(value => value),
      capacityProviderStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      platformVersion.map(value => value),
      platformFamily.map(value => value),
      taskDefinition.map(value => value),
      deploymentConfiguration.map(value => value.asEditable),
      taskSets.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      deployments.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      roleArn.map(value => value),
      events.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdAt.map(value => value),
      placementConstraints.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      placementStrategy.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      networkConfiguration.map(value => value.asEditable),
      healthCheckGracePeriodSeconds.map(value => value),
      schedulingStrategy.map(value => value),
      deploymentController.map(value => value.asEditable),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdBy.map(value => value),
      enableECSManagedTags.map(value => value),
      propagateTags.map(value => value),
      enableExecuteCommand.map(value => value)
    )
    def serviceArn: Option[String]
    def serviceName: Option[String]
    def clusterArn: Option[String]
    def loadBalancers: Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]]
    def serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]]
    def status: Option[String]
    def desiredCount: Option[Integer]
    def runningCount: Option[Integer]
    def pendingCount: Option[Integer]
    def launchType: Option[zio.aws.ecs.model.LaunchType]
    def capacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def platformVersion: Option[String]
    def platformFamily: Option[String]
    def taskDefinition: Option[String]
    def deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly]
    def taskSets: Option[List[zio.aws.ecs.model.TaskSet.ReadOnly]]
    def deployments: Option[List[zio.aws.ecs.model.Deployment.ReadOnly]]
    def roleArn: Option[String]
    def events: Option[List[zio.aws.ecs.model.ServiceEvent.ReadOnly]]
    def createdAt: Option[Timestamp]
    def placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]]
    def placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]]
    def networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly]
    def healthCheckGracePeriodSeconds: Option[BoxedInteger]
    def schedulingStrategy: Option[zio.aws.ecs.model.SchedulingStrategy]
    def deploymentController
        : Option[zio.aws.ecs.model.DeploymentController.ReadOnly]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def createdBy: Option[String]
    def enableECSManagedTags: Option[Boolean]
    def propagateTags: Option[zio.aws.ecs.model.PropagateTags]
    def enableExecuteCommand: Option[Boolean]
    def getServiceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceArn", serviceArn)
    def getServiceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getLoadBalancers
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] =
      AwsError.unwrapOptionField("loadBalancers", loadBalancers)
    def getServiceRegistries
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] =
      AwsError.unwrapOptionField("serviceRegistries", serviceRegistries)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getDesiredCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("desiredCount", desiredCount)
    def getRunningCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("runningCount", runningCount)
    def getPendingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("pendingCount", pendingCount)
    def getLaunchType: ZIO[Any, AwsError, zio.aws.ecs.model.LaunchType] =
      AwsError.unwrapOptionField("launchType", launchType)
    def getCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityProviderStrategy",
      capacityProviderStrategy
    )
    def getPlatformVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("platformFamily", platformFamily)
    def getTaskDefinition: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("taskDefinition", taskDefinition)
    def getDeploymentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ecs.model.DeploymentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deploymentConfiguration",
      deploymentConfiguration
    )
    def getTaskSets
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      AwsError.unwrapOptionField("taskSets", taskSets)
    def getDeployments
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.Deployment.ReadOnly]] =
      AwsError.unwrapOptionField("deployments", deployments)
    def getRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ServiceEvent.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getPlacementConstraints: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementConstraint.ReadOnly
    ]] =
      AwsError.unwrapOptionField("placementConstraints", placementConstraints)
    def getPlacementStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.PlacementStrategy.ReadOnly
    ]] = AwsError.unwrapOptionField("placementStrategy", placementStrategy)
    def getNetworkConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.NetworkConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("networkConfiguration", networkConfiguration)
    def getHealthCheckGracePeriodSeconds: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField(
        "healthCheckGracePeriodSeconds",
        healthCheckGracePeriodSeconds
      )
    def getSchedulingStrategy
        : ZIO[Any, AwsError, zio.aws.ecs.model.SchedulingStrategy] =
      AwsError.unwrapOptionField("schedulingStrategy", schedulingStrategy)
    def getDeploymentController
        : ZIO[Any, AwsError, zio.aws.ecs.model.DeploymentController.ReadOnly] =
      AwsError.unwrapOptionField("deploymentController", deploymentController)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCreatedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getEnableECSManagedTags: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableECSManagedTags", enableECSManagedTags)
    def getPropagateTags: ZIO[Any, AwsError, zio.aws.ecs.model.PropagateTags] =
      AwsError.unwrapOptionField("propagateTags", propagateTags)
    def getEnableExecuteCommand: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableExecuteCommand", enableExecuteCommand)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.Service
  ) extends zio.aws.ecs.model.Service.ReadOnly {
    override val serviceArn: Option[String] =
      scala.Option(impl.serviceArn()).map(value => value: String)
    override val serviceName: Option[String] =
      scala.Option(impl.serviceName()).map(value => value: String)
    override val clusterArn: Option[String] =
      scala.Option(impl.clusterArn()).map(value => value: String)
    override val loadBalancers
        : Option[List[zio.aws.ecs.model.LoadBalancer.ReadOnly]] = scala
      .Option(impl.loadBalancers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.LoadBalancer.wrap(item)
        }.toList
      )
    override val serviceRegistries
        : Option[List[zio.aws.ecs.model.ServiceRegistry.ReadOnly]] = scala
      .Option(impl.serviceRegistries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ServiceRegistry.wrap(item)
        }.toList
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val desiredCount: Option[Integer] =
      scala.Option(impl.desiredCount()).map(value => value: Integer)
    override val runningCount: Option[Integer] =
      scala.Option(impl.runningCount()).map(value => value: Integer)
    override val pendingCount: Option[Integer] =
      scala.Option(impl.pendingCount()).map(value => value: Integer)
    override val launchType: Option[zio.aws.ecs.model.LaunchType] = scala
      .Option(impl.launchType())
      .map(value => zio.aws.ecs.model.LaunchType.wrap(value))
    override val capacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.capacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
    override val platformVersion: Option[String] =
      scala.Option(impl.platformVersion()).map(value => value: String)
    override val platformFamily: Option[String] =
      scala.Option(impl.platformFamily()).map(value => value: String)
    override val taskDefinition: Option[String] =
      scala.Option(impl.taskDefinition()).map(value => value: String)
    override val deploymentConfiguration
        : Option[zio.aws.ecs.model.DeploymentConfiguration.ReadOnly] = scala
      .Option(impl.deploymentConfiguration())
      .map(value => zio.aws.ecs.model.DeploymentConfiguration.wrap(value))
    override val taskSets: Option[List[zio.aws.ecs.model.TaskSet.ReadOnly]] =
      scala
        .Option(impl.taskSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.TaskSet.wrap(item)
          }.toList
        )
    override val deployments
        : Option[List[zio.aws.ecs.model.Deployment.ReadOnly]] = scala
      .Option(impl.deployments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Deployment.wrap(item)
        }.toList
      )
    override val roleArn: Option[String] =
      scala.Option(impl.roleArn()).map(value => value: String)
    override val events: Option[List[zio.aws.ecs.model.ServiceEvent.ReadOnly]] =
      scala
        .Option(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ecs.model.ServiceEvent.wrap(item)
          }.toList
        )
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.ecs.model.primitives.Timestamp(value))
    override val placementConstraints
        : Option[List[zio.aws.ecs.model.PlacementConstraint.ReadOnly]] = scala
      .Option(impl.placementConstraints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementConstraint.wrap(item)
        }.toList
      )
    override val placementStrategy
        : Option[List[zio.aws.ecs.model.PlacementStrategy.ReadOnly]] = scala
      .Option(impl.placementStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.PlacementStrategy.wrap(item)
        }.toList
      )
    override val networkConfiguration
        : Option[zio.aws.ecs.model.NetworkConfiguration.ReadOnly] = scala
      .Option(impl.networkConfiguration())
      .map(value => zio.aws.ecs.model.NetworkConfiguration.wrap(value))
    override val healthCheckGracePeriodSeconds: Option[BoxedInteger] = scala
      .Option(impl.healthCheckGracePeriodSeconds())
      .map(value => value: BoxedInteger)
    override val schedulingStrategy
        : Option[zio.aws.ecs.model.SchedulingStrategy] = scala
      .Option(impl.schedulingStrategy())
      .map(value => zio.aws.ecs.model.SchedulingStrategy.wrap(value))
    override val deploymentController
        : Option[zio.aws.ecs.model.DeploymentController.ReadOnly] = scala
      .Option(impl.deploymentController())
      .map(value => zio.aws.ecs.model.DeploymentController.wrap(value))
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val createdBy: Option[String] =
      scala.Option(impl.createdBy()).map(value => value: String)
    override val enableECSManagedTags: Option[Boolean] =
      scala.Option(impl.enableECSManagedTags()).map(value => value: Boolean)
    override val propagateTags: Option[zio.aws.ecs.model.PropagateTags] = scala
      .Option(impl.propagateTags())
      .map(value => zio.aws.ecs.model.PropagateTags.wrap(value))
    override val enableExecuteCommand: Option[Boolean] =
      scala.Option(impl.enableExecuteCommand()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.Service
  ): zio.aws.ecs.model.Service.ReadOnly = new Wrapper(impl)
}
