package zio.aws.ecs.model
import java.lang.Integer
import zio.aws.ecs.model.primitives.BoxedInteger
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NetworkBinding(
    bindIP: Option[String] = None,
    containerPort: Option[BoxedInteger] = None,
    hostPort: Option[BoxedInteger] = None,
    protocol: Option[zio.aws.ecs.model.TransportProtocol] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.NetworkBinding = {
    import NetworkBinding.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.NetworkBinding
      .builder()
      .optionallyWith(bindIP.map(value => value: java.lang.String))(_.bindIP)
      .optionallyWith(containerPort.map(value => value: Integer))(
        _.containerPort
      )
      .optionallyWith(hostPort.map(value => value: Integer))(_.hostPort)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.NetworkBinding.ReadOnly =
    zio.aws.ecs.model.NetworkBinding.wrap(buildAwsValue())
}
object NetworkBinding {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.NetworkBinding
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.NetworkBinding =
      zio.aws.ecs.model.NetworkBinding(
        bindIP.map(value => value),
        containerPort.map(value => value),
        hostPort.map(value => value),
        protocol.map(value => value)
      )
    def bindIP: Option[String]
    def containerPort: Option[BoxedInteger]
    def hostPort: Option[BoxedInteger]
    def protocol: Option[zio.aws.ecs.model.TransportProtocol]
    def getBindIP: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bindIP", bindIP)
    def getContainerPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, BoxedInteger] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, zio.aws.ecs.model.TransportProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.NetworkBinding
  ) extends zio.aws.ecs.model.NetworkBinding.ReadOnly {
    override val bindIP: Option[String] =
      scala.Option(impl.bindIP()).map(value => value: String)
    override val containerPort: Option[BoxedInteger] =
      scala.Option(impl.containerPort()).map(value => value: BoxedInteger)
    override val hostPort: Option[BoxedInteger] =
      scala.Option(impl.hostPort()).map(value => value: BoxedInteger)
    override val protocol: Option[zio.aws.ecs.model.TransportProtocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.ecs.model.TransportProtocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.NetworkBinding
  ): zio.aws.ecs.model.NetworkBinding.ReadOnly = new Wrapper(impl)
}
