package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTasksResponse(
    taskArns: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTasksResponse = {
    import ListTasksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTasksResponse
      .builder()
      .optionallyWith(
        taskArns.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.taskArns)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.ListTasksResponse.ReadOnly =
    zio.aws.ecs.model.ListTasksResponse.wrap(buildAwsValue())
}
object ListTasksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTasksResponse =
      zio.aws.ecs.model.ListTasksResponse(
        taskArns.map(value => value),
        nextToken.map(value => value)
      )
    def taskArns: Option[List[String]]
    def nextToken: Option[String]
    def getTaskArns: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("taskArns", taskArns)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ) extends zio.aws.ecs.model.ListTasksResponse.ReadOnly {
    override val taskArns: Option[List[String]] = scala
      .Option(impl.taskArns())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTasksResponse
  ): zio.aws.ecs.model.ListTasksResponse.ReadOnly = new Wrapper(impl)
}
