package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTaskDefinitionFamiliesResponse(
    families: Option[Iterable[String]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse = {
    import ListTaskDefinitionFamiliesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
      .builder()
      .optionallyWith(
        families.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.families)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly =
    zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.wrap(buildAwsValue())
}
object ListTaskDefinitionFamiliesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse =
      zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse(
        families.map(value => value),
        nextToken.map(value => value)
      )
    def families: Option[List[String]]
    def nextToken: Option[String]
    def getFamilies: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("families", families)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ) extends zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly {
    override val families: Option[List[String]] = scala
      .Option(impl.families())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.ListTaskDefinitionFamiliesResponse
  ): zio.aws.ecs.model.ListTaskDefinitionFamiliesResponse.ReadOnly =
    new Wrapper(impl)
}
